/*
 * Decompiled with CFR 0.152.
 */
package rcon.event;

import java.sql.SQLException;
import java.util.ArrayList;
import rcon.database.Database;
import rcon.event.RCONEventAdapter;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.GameServer;
import rcon.server.OnlineList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsHandler
extends RCONEventAdapter {
    private Database db;
    private GameServer server;

    public StatsHandler(GameServer server, Database db) {
        this.server = server;
        this.db = db;
    }

    @Override
    public void onLeave(Player player, PlayerInfo info) {
        try {
            System.out.println(player.getId() + " " + player + " being updated.");
            if (player.getId() != 0) {
                this.db.stats.updateStats(player, true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRoundOverPlayers(ArrayList<PlayerInfo> info) {
        OnlineList online = this.server.getOnline();
        for (PlayerInfo i : info) {
            Player p = online.getByName(i.getName());
            if (p == null) continue;
            try {
                if (p.getId() == 0) continue;
                this.db.stats.updateStats(p, false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

