/*
 * Decompiled with CFR 0.152.
 */
package rcon.event;

import rcon.event.RCONEventAdapter;
import rcon.players.Player;
import rcon.server.GameServer;

public class StreakHandler
extends RCONEventAdapter {
    private GameServer server;
    private int modulus;
    private int bigLimit;

    public StreakHandler(GameServer server, int modulus, int bigLimit) {
        this.server = server;
        this.modulus = modulus;
        this.bigLimit = bigLimit;
    }

    public void onKill(Player killer, Player killed, String weapon, boolean headshot) {
        StringBuilder sb;
        int killerStreak;
        if (killer.getInfo().getTeam() != killed.getInfo().getTeam() && (killerStreak = killer.incrementStreak()) != 0 && killerStreak % this.modulus == 0) {
            sb = new StringBuilder();
            sb.append(killer.getName());
            sb.append(" is on a kill streak of ");
            sb.append(killerStreak);
            sb.append(" kills.");
            this.server.say(sb.toString());
        }
        int killedStreak = killed.getKillStreak();
        killed.resetStreak();
        if (killedStreak >= this.modulus) {
            sb = new StringBuilder();
            sb.append(killer.getName());
            sb.append(" ended ");
            if (killer.equals(killed)) {
                sb.append("his own kill streak of ");
            } else {
                sb.append(killed.getName());
                sb.append("'s kill streak of ");
            }
            sb.append(killedStreak);
            sb.append(" kills.");
            this.server.say(sb.toString());
        }
    }

    public void onSpawn(Player p, boolean first) {
        p.resetStreak();
    }
}

