/*
 * Decompiled with CFR 0.152.
 */
package rcon.ingame;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import rcon.ingame.ServerMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMessages {
    private ArrayList<ServerMessage> messages = new ArrayList();
    private int nextId = 1;
    private int nextIndex = 0;
    private String file = null;

    public ServerMessages() {
    }

    public ServerMessages(String file) {
        this();
        this.file = file;
    }

    public synchronized void setFile(String file) {
        this.file = file;
    }

    public synchronized void load() throws IOException {
        String line;
        if (this.file == null) {
            throw new IllegalStateException("No destination file set.");
        }
        BufferedReader r = new BufferedReader(new FileReader(this.file));
        while ((line = r.readLine()) != null) {
            if (line.isEmpty()) continue;
            this.addMessage(line);
        }
    }

    public synchronized void save() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("No target file set.");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.file));
        for (ServerMessage message : this.messages) {
            w.write(message.getMessage());
            w.write(10);
        }
        w.flush();
        w.close();
    }

    public synchronized ServerMessage addMessage(String message) {
        ServerMessage m = new ServerMessage(this.nextId++, message);
        this.messages.add(m);
        this.trySave();
        return m;
    }

    public synchronized int size() {
        return this.messages.size();
    }

    public synchronized ArrayList<ServerMessage> getMessages() {
        return new ArrayList<ServerMessage>(this.messages);
    }

    public synchronized void setMessage(int id, String message) {
        ListIterator<ServerMessage> it = this.find(id);
        if (it == null) {
            throw new NoSuchElementException("Unknown message id.");
        }
        it.set(new ServerMessage(id, message));
        this.trySave();
    }

    public synchronized void remove(int id) {
        ListIterator<ServerMessage> it = this.find(id);
        if (it == null) {
            throw new NoSuchElementException("No server message with id " + id + " exists.");
        }
        it.remove();
        this.trySave();
    }

    public synchronized ServerMessage next() {
        if (this.messages.isEmpty()) {
            return null;
        }
        if (this.nextIndex >= this.messages.size()) {
            this.nextIndex = 0;
        }
        return this.messages.get(this.nextIndex++);
    }

    public synchronized ServerMessage get(int id) {
        ListIterator<ServerMessage> it = this.find(id);
        if (it == null) {
            return null;
        }
        return it.previous();
    }

    private ListIterator<ServerMessage> find(int id) {
        ListIterator<ServerMessage> it = this.messages.listIterator();
        while (it.hasNext()) {
            if (it.next().getId() != id) continue;
            return it;
        }
        return null;
    }

    private void trySave() {
        if (this.file != null) {
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

