/*
 * Decompiled with CFR 0.152.
 */
package rcon.log;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import rcon.database.Database;
import rcon.database.DatabaseModule;
import rcon.log.AdminLogEntry;
import rcon.log.ChatLogEntry;
import rcon.log.EventLogEntry;
import rcon.players.Admin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogDatabase
extends DatabaseModule {
    public LogDatabase(Database database, String id) {
        super(database, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void admin(Admin admin, String message) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO logs_admin (time, source, admin, message) VALUES(?, ?, ?, ?)");
            stmt.setLong(1, Calendar.getInstance().getTimeInMillis() / 1000L);
            stmt.setString(2, this.id);
            stmt.setInt(3, admin.getId());
            stmt.setString(4, message);
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chat(String from, String to, String message) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO logs_chat (time, source, player, target, message) VALUES(?, ?, ?, ?, ?)");
            stmt.setLong(1, Calendar.getInstance().getTimeInMillis() / 1000L);
            stmt.setString(2, this.id);
            stmt.setString(3, from);
            stmt.setString(4, to);
            stmt.setString(5, message);
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(String message) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO logs_event (time, source, message) VALUES(?, ?, ?)");
            stmt.setLong(1, Calendar.getInstance().getTimeInMillis() / 1000L);
            stmt.setString(2, this.id);
            stmt.setString(3, message);
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AdminLogEntry> getAdminLogs(int start, int end, int limit, int offset) throws SQLException {
        ArrayList<AdminLogEntry> ret = new ArrayList<AdminLogEntry>();
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM logs_admin, admins WHERE logs_admin.admin = admins.id AND time >= ? AND time <= ? AND source = ? ORDER BY time ASC LIMIT ? OFFSET ?");
            stmt.setInt(1, start);
            stmt.setInt(2, end);
            stmt.setString(3, this.id);
            stmt.setInt(4, limit);
            stmt.setInt(5, offset);
            res = stmt.executeQuery();
            while (res.next()) {
                Admin admin = this.database.admins.parse(res);
                int time = res.getInt("logs_admin.time");
                String message = res.getString("logs_admin.message");
                AdminLogEntry entry = new AdminLogEntry(time, admin, message);
                ret.add(entry);
            }
        }
        catch (Throwable throwable) {
            this.close(con, stmt, res);
            throw throwable;
        }
        this.close(con, stmt, res);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AdminLogEntry> getAdminLogs(int adminId, int start, int end, int limit, int offset) throws SQLException {
        ArrayList<AdminLogEntry> ret = new ArrayList<AdminLogEntry>();
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM logs_admin, admins WHERE logs_admin.admin = admins.id AND time >= ? AND time <= ? AND logs_admin.admin = ? AND source = ? ORDER BY time ASC LIMIT ? OFFSET ?");
            stmt.setInt(1, start);
            stmt.setInt(2, end);
            stmt.setInt(3, adminId);
            stmt.setString(4, this.id);
            stmt.setInt(5, limit);
            stmt.setInt(6, offset);
            Admin admin = null;
            res = stmt.executeQuery();
            while (res.next()) {
                if (admin == null) {
                    admin = this.database.admins.parse(res);
                }
                int time = res.getInt("logs_admin.time");
                String message = res.getString("logs_admin.message");
                AdminLogEntry entry = new AdminLogEntry(time, admin, message);
                ret.add(entry);
            }
        }
        catch (Throwable throwable) {
            this.close(con, stmt, res);
            throw throwable;
        }
        this.close(con, stmt, res);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatLogEntry> getChatLogs(int start, int end, int limit, int offset) throws SQLException {
        ArrayList<ChatLogEntry> ret = new ArrayList<ChatLogEntry>();
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM logs_chat WHERE time >= ? AND time <= ? AND source = ? ORDER BY time ASC LIMIT ? OFFSET ?");
            stmt.setInt(1, start);
            stmt.setInt(2, end);
            stmt.setString(3, this.id);
            stmt.setInt(4, limit);
            stmt.setInt(5, offset);
            res = stmt.executeQuery();
            while (res.next()) {
                int time = res.getInt("time");
                String from = res.getString("player");
                String to = res.getString("target");
                String message = res.getString("message");
                ChatLogEntry entry = new ChatLogEntry(time, from, to, message);
                ret.add(entry);
            }
        }
        catch (Throwable throwable) {
            this.close(con, stmt, res);
            throw throwable;
        }
        this.close(con, stmt, res);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventLogEntry> getEventLogs(int start, int end, int limit, int offset) throws SQLException {
        ArrayList<EventLogEntry> ret = new ArrayList<EventLogEntry>();
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM logs_event WHERE time >= ? AND time <= ? AND source = ? ORDER BY time ASC LIMIT ? OFFSET ?");
            stmt.setInt(1, start);
            stmt.setInt(2, end);
            stmt.setString(3, this.id);
            stmt.setInt(4, limit);
            stmt.setInt(5, offset);
            res = stmt.executeQuery();
            while (res.next()) {
                int time = res.getInt("time");
                String message = res.getString("message");
                EventLogEntry entry = new EventLogEntry(time, message);
                ret.add(entry);
            }
        }
        catch (Throwable throwable) {
            this.close(con, stmt, res);
            throw throwable;
        }
        this.close(con, stmt, res);
        return ret;
    }
}

