/*
 * Decompiled with CFR 0.152.
 */
package rcon.net;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import rcon.MessageType;
import rcon.commands.Command;

public class RCONInputStream {
    private static final int MAX_PACKET_SIZE = 65535;
    private static final int MAX_PACKET_WORDS = 2048;
    private static final int MAX_WORD_LENGTH = 65535;
    static Logger logger = Logger.getLogger(RCONInputStream.class);
    private InputStream in;

    public RCONInputStream(InputStream in) {
        this.in = in;
    }

    private int readByte() throws IOException {
        int ret = this.in.read();
        if (ret == -1) {
            throw new IOException("End of stream");
        }
        return ret;
    }

    private long readU32() throws IOException {
        int a = this.readByte();
        int b = this.readByte();
        int c = this.readByte();
        int d = this.readByte();
        long ret = (long)(a | b << 8 | c << 16 | d << 24) & 0xFFFFFFFFL;
        return ret;
    }

    private String readWord() throws IOException {
        int len;
        int length = (int)this.readU32();
        if (length > 65535) {
            throw new IOException("Word size exceeds limit.");
        }
        byte[] data = new byte[length];
        for (int off = 0; off < length; off += len) {
            len = this.in.read(data, off, length - off);
            if (len != -1) continue;
            throw new IOException("End of stream");
        }
        this.readByte();
        return new String(data, "US-ASCII");
    }

    public Command readCommand() throws IOException {
        long seq = this.readU32();
        long size = this.readU32();
        int words = (int)this.readU32();
        if (size > 65535L) {
            throw new IOException("Packet size exceeds limit.");
        }
        if (words > 2048) {
            throw new IOException("Packet word count exceeds limit.");
        }
        String command = this.readWord();
        String[] arguments = new String[words - 1];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.readWord();
        }
        MessageType type = MessageType.get(seq & 0xC0000000L);
        Command cmd = new Command(command, type, (int)(seq & 0x3FFFFFFFL), arguments);
        logger.trace("<- " + cmd);
        return cmd;
    }
}

