/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import rcon.database.Database;
import rcon.database.DatabaseModule;
import rcon.players.Admin;
import rcon.players.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerDatabase
extends DatabaseModule {
    public PlayerDatabase(Database database, String id) {
        super(database, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("DELETE FROM players WHERE TRUE");
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Player player) throws SQLException {
        Admin admin;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            String query = "INSERT INTO players (name, pbguid, eaguid) VALUES(?, ?, ?) ON duplicate KEY UPDATE id=LAST_INSERT_ID(id), name = ?";
            if (!player.getPbGuid().isEmpty()) {
                query = query + ", pbguid = ?";
            }
            if (!player.getEaGuid().isEmpty()) {
                query = query + ", eaguid = ?";
            }
            stmt = con.prepareStatement(query, 1);
            int i = 1;
            stmt.setString(i++, player.getName());
            stmt.setString(i++, player.getPbGuid());
            stmt.setString(i++, player.getEaGuid());
            stmt.setString(i++, player.getName());
            if (!player.getPbGuid().isEmpty()) {
                stmt.setString(i++, player.getPbGuid());
            }
            if (!player.getEaGuid().isEmpty()) {
                stmt.setString(i++, player.getEaGuid());
            }
            stmt.executeUpdate();
            result = stmt.getGeneratedKeys();
            if (result.next()) {
                int id = result.getInt(1);
                player.setId(id);
            }
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        if (!player.getEaGuid().trim().isEmpty() && (admin = this.database.admins.getByGuid(player.getEaGuid())) != null) {
            player.setAdmin(admin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Player> find(String string, int offset, int limit) throws SQLException {
        ArrayList<Player> arrayList;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM players WHERE players.name LIKE ? ORDER BY players.name ASC LIMIT ? OFFSET ?");
            stmt.setString(1, string + "%");
            stmt.setInt(2, limit);
            stmt.setInt(3, offset);
            ArrayList<Player> players = new ArrayList<Player>();
            result = stmt.executeQuery();
            while (result.next()) {
                players.add(this.parse(result));
            }
            arrayList = players;
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    private Player parse(ResultSet result) throws SQLException {
        int id = result.getInt("players.id");
        String name = result.getString("players.name");
        String eaGuid = result.getString("players.eaguid");
        String pbGuid = result.getString("players.pbguid");
        String ip = "";
        return new Player(id, name, eaGuid, pbGuid, ip);
    }
}

