/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.util.ArrayList;
import rcon.commands.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerInfo {
    private String clanTag;
    private String name;
    private String eaGuid;
    private int team;
    private int squad;
    private int kills;
    private int deaths;
    private int score;
    private int ping;

    public PlayerInfo() {
        this.clanTag = "";
        this.name = "";
        this.eaGuid = "";
        this.team = 0;
        this.squad = 0;
        this.kills = 0;
        this.deaths = 0;
        this.score = 0;
        this.ping = 0;
    }

    public PlayerInfo(String name, String eaGuid) {
        this();
        this.name = name;
        this.eaGuid = eaGuid;
    }

    public PlayerInfo(PlayerInfo i) {
        this.clanTag = i.clanTag;
        this.name = i.name;
        this.eaGuid = i.eaGuid;
        this.team = i.team;
        this.squad = i.squad;
        this.kills = i.kills;
        this.deaths = i.deaths;
        this.score = i.score;
        this.ping = i.ping;
    }

    public static ArrayList<PlayerInfo> parse(Command command) {
        return PlayerInfo.parseInternal(command, 0);
    }

    public static PlayerInfo parseSingle(Command command) {
        ArrayList<PlayerInfo> info = PlayerInfo.parseInternal(command, 1);
        if (info.isEmpty()) {
            return null;
        }
        return info.get(0);
    }

    private static ArrayList<PlayerInfo> parseInternal(Command command, int offset) {
        ArrayList<PlayerInfo> players = new ArrayList<PlayerInfo>();
        int paramCount = command.getInt(offset++);
        Parameter[] parameters = new Parameter[paramCount];
        for (int j = 0; j < paramCount; ++j) {
            try {
                parameters[j] = Enum.valueOf(Parameter.class, command.get(offset++));
                continue;
            }
            catch (IllegalArgumentException e) {
                parameters[j] = Parameter.unknown;
            }
        }
        int playerCount = command.getInt(offset++);
        for (int j = 0; j < playerCount; ++j) {
            PlayerInfo player = new PlayerInfo();
            for (Parameter p : parameters) {
                switch (p) {
                    case clanTag: {
                        player.clanTag = command.get(offset);
                        break;
                    }
                    case deaths: {
                        player.deaths = command.getInt(offset);
                        break;
                    }
                    case guid: {
                        player.eaGuid = command.get(offset);
                        break;
                    }
                    case kills: {
                        player.kills = command.getInt(offset);
                        break;
                    }
                    case name: {
                        player.name = command.get(offset);
                        break;
                    }
                    case ping: {
                        player.ping = command.getInt(offset);
                        break;
                    }
                    case score: {
                        player.score = command.getInt(offset);
                        break;
                    }
                    case squadId: {
                        player.squad = command.getInt(offset);
                        break;
                    }
                    case teamId: {
                        player.team = command.getInt(offset);
                        break;
                    }
                }
                ++offset;
            }
            players.add(player);
        }
        return players;
    }

    public String getClanTag() {
        return this.clanTag;
    }

    public String getName() {
        return this.name;
    }

    public String getEaGuid() {
        return this.eaGuid;
    }

    public int getTeam() {
        return this.team;
    }

    public int getSquad() {
        return this.squad;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getScore() {
        return this.score;
    }

    public int getPing() {
        return this.ping;
    }

    public PlayerInfo eaGuid(String eaGuid) {
        PlayerInfo ret = new PlayerInfo(this);
        ret.eaGuid = eaGuid;
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Parameter {
        clanTag,
        name,
        guid,
        teamId,
        squadId,
        kills,
        deaths,
        score,
        ping,
        unknown;

    }
}

