/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import rcon.database.Database;
import rcon.database.DatabaseModule;
import rcon.players.Admin;
import rcon.players.Player;
import rcon.players.Punishment;
import rcon.players.PunishmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PunishmentDatabase
extends DatabaseModule {
    public PunishmentDatabase(Database database, String id) {
        super(database, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getActive(Player player, PunishmentType type) throws SQLException {
        ArrayList<Punishment> arrayList;
        String query = "SELECT * FROM bans, admins WHERE ((bans.eaguid = ? AND CHAR_LENGTH(bans.eaguid) > 0) OR (bans.pbguid = ? AND CHAR_LENGTH(bans.pbguid) > 0) OR (bans.name = ? AND CHAR_LENGTH(bans.name) > 0) ) AND bans.type = ? AND admins.id = bans.issuer AND (bans.endtime > ? OR bans.endtime = 0) AND bans.enabled = TRUE";
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setString(1, player.getEaGuid());
            stmt.setString(2, player.getPbGuid());
            stmt.setString(3, player.getName());
            stmt.setString(4, type.name());
            stmt.setLong(5, System.currentTimeMillis() / 1000L);
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getByPlayer(Player player) throws SQLException {
        ArrayList<Punishment> arrayList;
        String query = "SELECT * FROM bans, admins WHERE (bans.eaguid = ? OR bans.pbguid = ? OR bans.name = ?) AND admins.id = bans.issuer";
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setString(1, player.getEaGuid());
            stmt.setString(2, player.getPbGuid());
            stmt.setString(3, player.getName());
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getByName(String name, boolean partial) throws SQLException {
        ArrayList<Punishment> arrayList;
        String query = partial ? "SELECT * FROM bans, admins WHERE admins.id = bans.issuer AND bans.name LIKE ?" : "SELECT * FROM bans, admins WHERE bans.name = ? AND admins.id = bans.issuer";
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(query);
            if (partial) {
                stmt.setString(1, name + "%");
            } else {
                stmt.setString(1, name);
            }
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getByPbGuid(String guid) throws SQLException {
        ArrayList<Punishment> arrayList;
        String query = "SELECT * FROM bans, admins WHERE bans.pbguid = ? AND admins.id = bans.issuer";
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setString(1, guid);
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getByEaGuid(String guid) throws SQLException {
        ArrayList<Punishment> arrayList;
        String query = "SELECT * FROM bans, admins WHERE bans.eaguid = ? AND admins.id = bans.issuer";
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setString(1, guid);
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getByAdmin(int adminId) throws SQLException {
        ArrayList<Punishment> arrayList;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM bans, admins WHERE bans.issuer = ? AND admins.id = bans.issuer");
            stmt.setInt(1, adminId);
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Punishment> getLast(EnumSet<PunishmentType> types, int amount) throws SQLException {
        ArrayList<Punishment> arrayList;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT * FROM bans, admins WHERE bans.type IN (");
            for (i = 0; i < types.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(") AND admins.id = bans.issuer LIMIT ?");
            stmt = con.prepareStatement(sb.toString());
            i = 1;
            for (PunishmentType t : types) {
                stmt.setString(i++, t.name());
            }
            stmt.setInt(i++, amount);
            result = stmt.executeQuery();
            arrayList = this.parsePunishments(result);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Punishment get(int id) throws SQLException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block3: {
            Punishment punishment;
            con = this.getConnection();
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("SELECT * FROM bans, admins WHERE bans.id = ? AND admins.id = bans.issuer");
                stmt.setInt(1, id);
                result = stmt.executeQuery();
                if (!result.next()) break block3;
                punishment = this.parse(result);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, result);
                throw throwable;
            }
            this.close(con, stmt, result);
            return punishment;
        }
        Punishment punishment = null;
        this.close(con, stmt, result);
        return punishment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Punishment punishment) throws SQLException {
        ResultSet keys;
        PreparedStatement stmt;
        Connection con;
        block3: {
            boolean bl;
            String query = "INSERT INTO bans (name, eaguid, pbguid, type, starttime, endtime, reason, issuer, enabled) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
            con = this.getConnection();
            stmt = null;
            keys = null;
            try {
                stmt = con.prepareStatement(query, 1);
                stmt.setString(1, punishment.getName());
                stmt.setString(2, punishment.getEaGuid());
                stmt.setString(3, punishment.getPbGuid());
                stmt.setString(4, punishment.getType().name());
                stmt.setLong(5, punishment.getStart());
                stmt.setLong(6, punishment.getEnd());
                stmt.setString(7, punishment.getReason());
                stmt.setInt(8, punishment.getIssuer().getId());
                stmt.setBoolean(9, punishment.isEnabled());
                stmt.executeUpdate();
                keys = stmt.getGeneratedKeys();
                if (!keys.next()) break block3;
                punishment.setId(keys.getInt(1));
                bl = true;
            }
            catch (Throwable throwable) {
                this.close(con, stmt, keys);
                throw throwable;
            }
            this.close(con, stmt, keys);
            return bl;
        }
        boolean bl = false;
        this.close(con, stmt, keys);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Punishment p) throws SQLException {
        String query = "UPDATE bans SET name = ?, eaguid = ?, pbguid = ?, type = ?, starttime = ?, endtime = ?, reason = ?, issuer = ?, enabled = ? WHERE id = ?";
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(query);
            stmt.setString(1, p.getName());
            stmt.setString(2, p.getEaGuid());
            stmt.setString(3, p.getPbGuid());
            stmt.setString(4, p.getType().name());
            stmt.setLong(5, p.getStart());
            stmt.setLong(6, p.getEnd());
            stmt.setString(7, p.getReason());
            stmt.setInt(8, p.getIssuer().getId());
            stmt.setBoolean(9, p.isEnabled());
            stmt.setInt(10, p.getId());
            boolean bl = stmt.executeUpdate() == 1;
            return bl;
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int id) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("UPDATE bans SET enabled = FALSE WHERE id = ?");
            stmt.setInt(1, id);
            boolean bl = stmt.executeUpdate() == 1;
            return bl;
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReason(String shortcut) throws SQLException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block3: {
            String string;
            con = this.getConnection();
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("SELECT * FROM reasons WHERE shortcut = ?");
                stmt.setString(1, shortcut.toLowerCase());
                result = stmt.executeQuery();
                if (!result.next()) break block3;
                string = result.getString("reasons.explaination");
            }
            catch (Throwable throwable) {
                this.close(con, stmt, result);
                throw throwable;
            }
            this.close(con, stmt, result);
            return string;
        }
        String string = shortcut;
        this.close(con, stmt, result);
        return string;
    }

    private ArrayList<Punishment> parsePunishments(ResultSet result) throws SQLException {
        ArrayList<Punishment> punishments = new ArrayList<Punishment>();
        if (result.next()) {
            do {
                Punishment punishment = this.parse(result);
                punishments.add(punishment);
            } while (result.next());
        }
        return punishments;
    }

    private Punishment parse(ResultSet result) throws SQLException {
        Admin admin = this.database.admins.parse(result);
        int id = result.getInt("bans.id");
        String bannedName = result.getString("bans.name");
        String bannedEaGuid = result.getString("bans.eaguid");
        String bannedPbGuid = result.getString("bans.pbguid");
        String typeString = result.getString("bans.type");
        PunishmentType type = Enum.valueOf(PunishmentType.class, typeString);
        long start = result.getLong("bans.starttime");
        long end = result.getLong("bans.endtime");
        String reason = result.getString("bans.reason");
        boolean enabled = result.getBoolean("bans.enabled");
        Punishment punishment = new Punishment(bannedName, bannedEaGuid, bannedPbGuid, type, start, end, reason, admin, enabled);
        punishment.setId(id);
        return punishment;
    }
}

