/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import rcon.database.Database;
import rcon.database.DatabaseModule;
import rcon.players.Player;
import rcon.players.Report;

public class ReportDatabase
extends DatabaseModule {
    public ReportDatabase(Database database, String id) {
        super(database, id);
    }

    public void abandon(Report report) throws SQLException {
        if (this.changeType(report, "live", "abandoned")) {
            this.addUpdate(report, "abandoned");
        }
    }

    public void comment(Report report, String comment) throws SQLException {
        this.addComment(report, comment);
        this.refresh(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report submitReport(Player player, String summary, String description) throws SQLException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block3: {
            Report report;
            con = this.getConnection();
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("INSERT INTO reports VALUES(0, ?, NULL, UNIX_TIMESTAMP(NOW()), UNIX_TIMESTAMP(NOW()), NULL, 'new', 'live', ?, ?)", 1);
                stmt.setString(1, player.getName());
                stmt.setString(2, summary);
                stmt.setString(3, description);
                if (stmt.executeUpdate() != 1) break block3;
                result = stmt.getGeneratedKeys();
                result.next();
                int id = result.getInt(1);
                report = new Report(id);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, result);
                throw throwable;
            }
            this.close(con, stmt, result);
            return report;
        }
        Report report = null;
        this.close(con, stmt, result);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(Report report) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("UPDATE reports SET updated = UNIX_TIMESTAMP(NOW()) WHERE id = ?");
            stmt.setInt(1, report.getId());
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeType(Report report, String oldType, String type) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("UPDATE reports SET updated = UNIX_TIMESTAMP(NOW()), type = ? WHERE id = ? AND type = ?");
            stmt.setString(1, type);
            stmt.setInt(2, report.getId());
            stmt.setString(3, oldType);
            if (stmt.executeUpdate() == 1) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.close(con, stmt, result);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComment(Report report, String comment) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("INSERT INTO report_post VALUES(0, ?, NULL, UNIX_TIMESTAMP(NOW()), ?)");
            stmt.setInt(1, report.getId());
            stmt.setString(2, comment);
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdate(Report report, String type) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("INSERT INTO report_update VALUES(0, ?, NULL, UNIX_TIMESTAMP(NOW()), NULL, NULL, ?, NULL)");
            stmt.setInt(1, report.getId());
            stmt.setString(2, type);
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, result);
        }
    }
}

