/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import rcon.database.Database;
import rcon.database.DatabaseModule;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.players.Ranking;

public class StatsDatabase
extends DatabaseModule {
    public StatsDatabase(Database database, String id) {
        super(database, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(Player player, boolean disconnect) throws SQLException {
        PlayerInfo info = player.getInfo();
        int id = player.getId();
        int kills = info.getKills();
        int deaths = info.getDeaths();
        int score = info.getScore();
        long time = disconnect ? Calendar.getInstance().getTimeInMillis() / 1000L - player.getCreated() : 0L;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("INSERT INTO stats (id, kills, deaths, score, time) VALUES(?, ?, ?, ?, ?) ON duplicate KEY UPDATE kills = kills + ?, deaths = deaths + ?, score = score + ?, time = time + ?");
            int i = 1;
            stmt.setInt(i++, id);
            stmt.setInt(i++, kills);
            stmt.setInt(i++, deaths);
            stmt.setInt(i++, score);
            stmt.setLong(i++, time);
            stmt.setInt(i++, kills);
            stmt.setInt(i++, deaths);
            stmt.setInt(i++, score);
            stmt.setLong(i++, time);
            stmt.executeUpdate();
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ranking getRank(Player player) throws SQLException {
        Ranking ranking;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT COUNT(*)+1 AS rank, (SELECT COUNT(*) FROM stats) AS count FROM stats WHERE score > COALESCE((SELECT score FROM stats WHERE id = ?), 0)");
            stmt.setInt(1, player.getId());
            result = stmt.executeQuery();
            result.next();
            int rank = result.getInt("rank");
            int count = result.getInt("count");
            ranking = new Ranking(rank, count);
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return ranking;
    }
}

