/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Properties;

public class Configuration {
    private String filename;
    private EnumMap<Variable, String> config = new EnumMap(Variable.class);
    private EnumSet<Variable> enforced = EnumSet.noneOf(Variable.class);

    public synchronized void save() throws IOException {
        Properties p = new Properties();
        for (Variable v : this.enforced) {
            p.setProperty(v.getName(), this.config.get((Object)v));
        }
        p.store(new FileWriter(this.filename), "Server configuration");
    }

    public synchronized void load(String filename) throws IOException {
        Properties p = new Properties();
        p.load(new FileReader(filename));
        for (Variable v : Variable.values()) {
            String value = p.getProperty(v.getName());
            if (value == null) continue;
            this.config.put(v, value);
            this.enforced.add(v);
        }
        this.filename = filename;
    }

    public synchronized String get(Variable var) {
        return this.config.get((Object)var);
    }

    public synchronized void enforce(Variable var, String value) {
        this.config.put(var, value);
        this.enforced.add(var);
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean isEnforced(Variable var) {
        return this.enforced.contains((Object)var);
    }

    public synchronized void unenforce(Variable var) {
        this.enforced.remove((Object)var);
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void update(Variable var, String value) {
        if (this.isEnforced(var)) {
            throw new IllegalArgumentException("Unable to update an enforced variable.");
        }
        this.config.put(var, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variable {
        miniMapSpotting,
        teamKillCountForKick,
        gamePassword,
        serverDescription,
        teamKillValueForKick,
        maxPlayers,
        bulletDamage,
        nameTag,
        teamKillValueIncrease,
        regenerateHealth,
        cam3p("3pCam"),
        teamKillKickForBan,
        vehicleSpawnDelay,
        bannerUrl,
        friendlyFire,
        vehicleSpawnAllowed,
        roundRestartPlayerCount,
        idleTimeout,
        minimap,
        serverMessage,
        onlySquadLeaderSpawn,
        allUnlocksUnlocked,
        clientSideDamageArbitration,
        killCam,
        soldierHealth,
        idleBanRounds,
        spotting3d("3dSpotting"),
        hud,
        killRotation,
        playerManDownTime,
        serverName,
        roundStartPlayerCount,
        gameModeCounter,
        playerRespawnTime,
        autoBalance,
        roundsPerMap,
        teamKillValueDecreasePerSecond;

        private static HashMap<String, Variable> variables;
        private final String realName;

        public static Variable get(String name) {
            return variables.get(name);
        }

        private Variable() {
            this.realName = null;
        }

        private Variable(String realName) {
            this.realName = realName;
        }

        public String getName() {
            return this.realName == null ? this.name() : this.realName;
        }

        static {
            variables = new HashMap();
            for (Variable var : Variable.values()) {
                variables.put(var.getName(), var);
            }
        }
    }
}

