/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import org.apache.log4j.Logger;
import rcon.server.GameServer;

public class HeartbeatChecker
implements Runnable {
    static Logger logger = Logger.getLogger(HeartbeatChecker.class);
    private GameServer server;
    private volatile boolean enabled;

    public HeartbeatChecker(GameServer server) {
        this.server = server;
        this.enabled = true;
    }

    public void run() {
        if (!this.enabled) {
            throw new IllegalStateException("Heartbeats are disabled.");
        }
        logger.trace("Sending heartbeat command...");
        int version = this.server.getVersion();
        if (version == -1) {
            logger.warn("Invalid response from hearbeat command.");
        } else {
            logger.trace("Heartbeat response received. ");
        }
    }

    public void stop() {
        this.enabled = false;
    }
}

