/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import rcon.players.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineList {
    static Logger logger = Logger.getLogger(OnlineList.class);
    private HashMap<String, Player> players = new HashMap();
    private Player server = null;

    public synchronized Player getByName(String name) {
        Player player = this.players.get(name);
        if (player == null && this.server != null && this.server.getName().equals(name)) {
            player = this.server;
        }
        return player;
    }

    public synchronized Player ensureGetByName(String name) {
        Player player = this.players.get(name);
        if (player == null && this.server != null && this.server.getName().equals(name)) {
            player = this.server;
        } else if (player == null) {
            player = new Player(name);
            this.players.put(name, player);
            logger.debug("Adding missing player to online list - " + name + ".");
            this.print(Thread.currentThread().getStackTrace());
        }
        return player;
    }

    private void print(StackTraceElement[] trace) {
        for (StackTraceElement e : trace) {
            logger.trace(e.toString());
        }
    }

    public synchronized ArrayList<Player> getByPartialName(String text) {
        ArrayList<Player> matches = new ArrayList<Player>();
        for (Player p : this.players.values()) {
            if (!p.getFullName().toLowerCase().contains(text.toLowerCase())) continue;
            matches.add(p);
        }
        return matches;
    }

    public synchronized ArrayList<Player> getPlayers() {
        return new ArrayList<Player>(this.players.values());
    }

    protected synchronized void addPlayer(Player player) {
        this.players.put(player.getName(), player);
        logger.debug("Unconditionally adding player to online list - " + player.toString() + ".");
        this.print(Thread.currentThread().getStackTrace());
    }

    protected synchronized void removePlayer(Player player) {
        this.players.remove(player.getName());
        logger.debug("Unconditionally removing player from online list - " + player + ".");
        this.print(Thread.currentThread().getStackTrace());
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Online player list:\n");
        for (Player p : this.players.values()) {
            sb.append(p.getFullName());
            sb.append(": ");
            sb.append(p.getEaGuid());
            sb.append(", ");
            sb.append(p.getPbGuid());
            sb.append(", ");
            sb.append(p.getIp());
            sb.append('\n');
        }
        return sb.toString();
    }

    public synchronized ArrayList<Player> getAdmins() {
        ArrayList<Player> admins = new ArrayList<Player>();
        for (Player p : this.players.values()) {
            if (!p.isAdmin()) continue;
            admins.add(p);
        }
        return admins;
    }

    public synchronized int size() {
        return this.players.size();
    }

    public synchronized void setServerPlayer(Player player) {
        this.server = player;
        System.out.println("Set server player to " + player.getName() + " " + player.getAdmin().getId() + ".");
    }
}

