/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import rcon.players.Player;
import rcon.server.GameServer;

public class PlayerUpdater
implements Runnable {
    static Logger logger = Logger.getLogger(PlayerUpdater.class);
    private GameServer server;
    private volatile boolean enabled;
    private int timeout;

    public PlayerUpdater(GameServer server, int timeout) {
        this.server = server;
        this.enabled = true;
        this.timeout = timeout;
    }

    public void run() {
        if (this.enabled) {
            this.server.requestPlayerInfo();
            ArrayList<Player> players = this.server.getOnline().getPlayers();
            for (Player p : players) {
                long elapsedTime = System.currentTimeMillis() - p.getLastUpdate();
                if (elapsedTime <= (long)this.timeout) continue;
                logger.info("Player " + p.getName() + " have timed out. Last update was " + (double)elapsedTime / 1000.0 + " seconds ago. Removing from cache.");
                this.server.getOnline().removePlayer(p);
            }
        } else {
            throw new IllegalStateException("Player updater disabled.");
        }
        this.server.updateInfo();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

