/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.log4j.Logger;
import rcon.ingame.ServerMessage;
import rcon.ingame.ServerMessages;
import rcon.server.GameServer;

public class ServerMessenger
implements Runnable {
    static Logger logger = Logger.getLogger(ServerMessenger.class);
    private ServerMessages messages;
    private GameServer server;
    private volatile boolean enabled;

    public ServerMessenger(GameServer server, ServerMessages messages) {
        this.messages = messages;
        this.server = server;
        this.enabled = true;
    }

    public void run() {
        if (!this.enabled) {
            throw new IllegalStateException("Heartbeats are disabled.");
        }
        ServerMessage m = this.messages.next();
        if (m != null) {
            logger.trace("Sending server message \"" + m.getMessage() + "\".");
            String message = m.getMessage();
            BufferedReader r = new BufferedReader(new StringReader(message));
            try {
                String line;
                while ((line = r.readLine()) != null) {
                    this.server.say(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void stop() {
        this.enabled = false;
    }
}

