CREATE TABLE players (
	id INTEGER AUTO_INCREMENT,
	name VARCHAR(50),
	pbguid VARCHAR(32),
	eaguid VARCHAR(36),
	PRIMARY KEY(id),
	UNIQUE(name)
);
CREATE INDEX ix_players_name ON players(name);

CREATE TABLE admins (
	id INTEGER AUTO_INCREMENT, 
	guid VARCHAR(36), 
	username VARCHAR(50), 
	password VARCHAR(50), 
	rights VARCHAR(500),
	PRIMARY KEY(id),
	UNIQUE(guid),
	UNIQUE(username)
);
CREATE INDEX ix_admins_username ON admins(username);

CREATE TABLE  bans (
  id INTEGER AUTO_INCREMENT,
  name VARCHAR(50),
  pbguid VARCHAR(32),
  eaguid VARCHAR(36),
  type VARCHAR(10),
  startTime INTEGER,
  endTime INTEGER,
  reason VARCHAR(150),
  issuer INTEGER,
  enabled BOOLEAN,
  PRIMARY KEY(id),
  FOREIGN KEY (issuer) REFERENCES admins(id)
);
CREATE INDEX ix_bans_name ON bans(name);
CREATE INDEX ix_bans_pbguid ON bans(pbguid);
CREATE INDEX ix_bans_eaguid ON bans(eaguid);
CREATE INDEX ix_bans_type ON bans(type);
CREATE INDEX ix_bans_starttime ON bans(starttime);
CREATE INDEX ix_bans_endtime ON bans(endtime);


CREATE VIEW ban_count_by_name AS SELECT name, COUNT(*) amount FROM bans WHERE type = 'ban' AND enabled = 1 GROUP BY name;
CREATE VIEW ban_count_by_eaguid AS SELECT eaguid, COUNT(*) eaguid_amount FROM bans WHERE type = 'ban' AND enabled = 1 GROUP BY eaguid;


CREATE TABLE reasons (
	shortcut VARCHAR(20), 
	explaination VARCHAR(100), 
	PRIMARY KEY(shortcut)
);

INSERT INTO reasons (shortcut, explaination) VALUES('glitch', 'Glitching'),
	('pad', 'Stats Padding'),
	('lang', 'Bad/Racist Language'),
	('tard', 'Being a Smacktard. KNOCK IT OFF'),
	('copycat', 'Being in a clan that copies the Timeless name'),
	('spoil', 'Spoiling gameplay'),
	('rape', 'Baserape or Killing in uncap spawn areas'),
	('noob', 'Being a complete NOOB'),
	('spam', 'Spamming messages'),
	('sexy', 'Being too sexy for this server'),
	('pbbans', 'Being caught cheating by PBbans'),
	('cheat', 'Cheating / using hacks'),
	('bot', 'Using an aimbot'),
	('dax', 'Being Dax'),
	('banned', 'You Are Banned from Timeless servers - www.timelessgaming.com');


CREATE TABLE logs_admin (
	time INTEGER,
	source VARCHAR(30),
	admin INTEGER,
	message VARCHAR(200),
	FOREIGN KEY (admin) REFERENCES admins(id)
);
CREATE INDEX ix_logs_admin_time ON logs_admin(time);


CREATE TABLE logs_event (
	time INTEGER,
	source VARCHAR(30),
	message VARCHAR(200)
);
CREATE INDEX ix_logs_event_time ON logs_event(time);

CREATE TABLE logs_chat (
	time INTEGER,
	source VARCHAR(30),
	player VARCHAR(50),
	target VARCHAR(50),
	message VARCHAR(200)
);
CREATE INDEX ix_logs_chat_time ON logs_chat(time);
CREATE INDEX ix_logs_chat_player ON logs_chat(player);
CREATE INDEX ix_logs_chat_source ON logs_chat(source);

CREATE TABLE stats (
	id INTEGER,
	kills INTEGER DEFAULT 0,
	deaths INTEGER DEFAULT 0,
	score INTEGER DEFAULT 0,
	time INTEGER DEFAULT 0,
	PRIMARY KEY(id),
	FOREIGN KEY (id) REFERENCES players(id)
);
CREATE INDEX ix_stats_kills ON stats(kills);
CREATE INDEX ix_stats_score ON stats(score);
CREATE INDEX ix_stats_time ON stats(time);



CREATE TABLE report_status (
	status VARCHAR(20) NOT NULL,
	PRIMARY KEY(status)
);
INSERT INTO report_status (status) VALUES('new'), ('assigned'), ('resolved'), ('ignored');

CREATE TABLE report_type (
	type VARCHAR(20) NOT NULL,
	PRIMARY KEY(type)
);
INSERT INTO report_type (type) VALUES('live'), ('abandoned'), ('language'), ('rape'), ('cheat'), ('other');


CREATE TABLE reports (
	id INTEGER AUTO_INCREMENT,
	reporter VARCHAR(50) NOT NULL,
	reported VARCHAR(50),
	started INTEGER NOT NULL,
	updated INTEGER NOT NULL,
	owner INTEGER,
	status VARCHAR(20) NOT NULL,
	type VARCHAR(20) NOT NULL,
	summary VARCHAR(100) NOT NULL,
	description TEXT,
	PRIMARY KEY(id),
	FOREIGN KEY (owner) REFERENCES admins(id),
	FOREIGN KEY (status) REFERENCES report_status(status),
	FOREIGN KEY (type) REFERENCES report_type(type)
);
CREATE INDEX ix_reports_updated ON reports(updated);
CREATE INDEX ix_reports_status ON reports(status);

CREATE TABLE report_post (
	id INTEGER AUTO_INCREMENT,
	report INTEGER NOT NULL,
	sender INTEGER,
	time INTEGER NOT NULL,
	message TEXT NOT NULL,
	PRIMARY KEY(id),
	FOREIGN KEY (report) REFERENCES report(id),
	FOREIGN KEY (sender) REFERENCES admins(id)
);
CREATE INDEX ix_report_post_time ON report_post(time);

CREATE TABLE report_update (
	id INTEGER AUTO_INCREMENT,
	report INTEGER NOT NULL,
	sender INTEGER,
	time INTEGER NOT NULL,
	owner INTEGER,
	status VARCHAR(20),
	type VARCHAR(20),
	reported VARCHAR(50),
	PRIMARY KEY(id),
	FOREIGN KEY (report) REFERENCES report(id),
	FOREIGN KEY (sender) REFERENCES admins(id),
	FOREIGN KEY (owner) REFERENCES admins(id),
	FOREIGN KEY (status) REFERENCES report_status(status),
	FOREIGN KEY (type) REFERENCES report_type(type)
);
CREATE INDEX ix_report_update_time ON report_update(time);