package rcon;

public enum MessageType {
	client_request(0x00000000L),
	client_response(0x40000000L),
	server_request(0x80000000L),
	server_response(0xC0000000L);
	
	public final long	flags;
	
	private MessageType(long flags) {
		this.flags = flags;
	}
	
	public static MessageType get(long i) {
		if(i == client_request.flags) {
			return client_request;
		} else if(i == client_response.flags) {
			return client_response;
		} else if(i == server_request.flags) {
			return server_request;
		} else if(i == server_response.flags) {
			return server_response;
		} else {
			return null;
		}
	}
	
	@Override
	public String toString() {
		switch(this) {
			case client_request:
				return "creq";
			case client_response:
				return "cres";
			case server_request:
				return "sreq";
			case server_response:
				return "sres";
			default:
				return "";
		}
	}
}
