package rcon;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Scheduler {
	
	private static final int SHUTDOWN_GRACE = 1000;
	private static final int DEFAULT_POOL_SIZE = 16;
	
	public static final Scheduler instance = new Scheduler();
	
	private ScheduledExecutorService executor;
	
	public static Scheduler getInstance() {
		return instance;
	}
	
	private Scheduler() {
		this(DEFAULT_POOL_SIZE);
	}
	
	private Scheduler(int threads) {
		executor = Executors.newScheduledThreadPool(threads, new DaemonThreadFactory());
	}
	
	public void schedule(Runnable task, int delay) {
		executor.schedule(task, delay, TimeUnit.MILLISECONDS);
	}
	
	public void repeat(Runnable task, int period) {
		executor.scheduleAtFixedRate(task, period, period, TimeUnit.MILLISECONDS);
	}
	
	public void execute(Runnable task) {
		executor.submit(task);
	}
	
	public void stop() {
		executor.shutdown();
		try {
			executor.awaitTermination(SHUTDOWN_GRACE, TimeUnit.MILLISECONDS);
		} catch (InterruptedException e) {
			executor.shutdownNow();
		}
	}
	
}
