package rcon.client;

import java.util.EnumSet;
import java.util.HashMap;

import rcon.players.Right;

public enum ClientCommand {
	VERSION("version"), 
	LOGOUT("logout"),
	QUIT("quit"),
	//EVENTS_ENABLED("eventsEnabled", Right.console),
	SHUTDOWN("shutdown", Right.shutdownDaemon),
	LOGIN_HASHED("login.hashed"),
	DAEMON_STATUS("daemon.status", Right.console),
	SERVER_STATUS("server.status", Right.console),
	CONFIG_SET("config.set", Right.changeConfiguration),
	CONFIG_GET("config.get", Right.console),
	CONFIG_CLEAR("config.clear", Right.changeConfiguration),
	CONFIG_LIST("config.list", Right.console),
	CONFIG_ALL("config.all", Right.console),
	BANS_LIST("bans.list", Right.listBans),
	BANS_HISTORY("bans.history", Right.playerHistory),
	BANS_REMOVE("bans.remove", Right.unban),
	BANS_WARN("bans.warn", Right.kick),
	BANS_KICK("bans.kick", Right.kick),
	BANS_BAN("bans.ban", Right.ban),
	BANS_EDIT("bans.edit", Right.unban),
	BANS_GET("bans.get", Right.listBans),
	ADMINS_SET_RIGHTS("admins.setRights", Right.setRights),
	ADMINS_GET("admins.get", Right.console), 
	ADMINS_SET_PASSWORD("admins.setPassword", Right.console),
	ADMINS_REGISTER("admins.register", Right.registerAdmin),
	ADMINS_EDIT("admins.edit", Right.editAdmin),
	ADMINS_LIST("admins.list", Right.console),
	PLAYERS_LIST("players.list", Right.console),
	PLAYERS_SEARCH("players.search", Right.console),
	PLAYERS_YELL("players.yell", Right.yell),
	PLAYERS_SAY("players.say", Right.yell),
	PUNKBUSTER_EXECUTE("punkbuster.execute", Right.pbAdmin),
	//MAPS_NEXT("maps.next", Right.runNextMap),
	//MAPS_RESTART("maps.restart", Right.restartMap),
	MESSAGES_LIST("messages.list", Right.console),
	MESSAGES_ADD("messages.add", Right.editMessages),
	MESSAGES_EDIT("messages.edit", Right.editMessages),
	MESSAGES_REMOVE("messages.remove", Right.editMessages),
	LOGS_ADMIN("logs.admin", Right.adminLogs),
	LOGS_CHAT("logs.chat", Right.chatLogs),
	LOGS_EVENT("logs.event", Right.eventLogs),
	RESERVEDSLOTS_LOAD("reservedSlots.load", Right.reservedSlots),
	RESERVEDSLOTS_SAVE("reservedSlots.save", Right.reservedSlots),
	RESERVEDSLOTS_CLEAR("reservedSlots.clear", Right.reservedSlots),
	RESERVEDSLOTS_LIST("reservedSlots.list", Right.console),
	RESERVEDSLOTS_ADDPLAYER("reservedSlots.addPlayer", Right.reservedSlots),
	RESERVEDSLOTS_REMOVEPLAYER("reservedSlots.removePlayer", Right.reservedSlots),
	// TODO: Map control
	;
	
	private static HashMap<String, ClientCommand> commands = new HashMap<String, ClientCommand>();
	
	static {
		for(ClientCommand command : ClientCommand.values()) {
			commands.put(command.getCommand(), command);
		}
	}
	
	private String command;
	private EnumSet<Right> rights;

	private ClientCommand(String command, EnumSet<Right> rights) {
		this.command = command;
		this.rights = rights;
	}
	
	private ClientCommand(String command, Right right, Right... rights) {
		this.command = command;
		this.rights = EnumSet.of(right, rights);
	}
	
	private ClientCommand(String command) {
		this.command = command;
		this.rights = EnumSet.noneOf(Right.class);
	}
	
	public String getCommand() {
		return command;
	}
	
	public boolean hasRights(EnumSet<Right> rights) {
		return rights.containsAll(this.rights);
	}
	
	public static ClientCommand get(String command) {
		return commands.get(command);
	}
	
}
