package rcon.client;

import java.io.IOException;
import java.util.ArrayList;

import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;
import rcon.server.Configuration;
import rcon.server.GameServer;

public class ConfigModule extends CommandModule {
	
	public ConfigModule(RCONOutputStream out, RCONDaemon daemon) {
		super(out, daemon);
	}
	
	public void set(Admin user, Command request) throws IOException {
		if(request.size() == 3) {
			String variableName = request.get(0);
			String value = request.get(1);
			boolean enforced = request.get(2).equals("true");
			
			Configuration.Variable var = Configuration.Variable.get(variableName);
			if(var == null) {
				reply(request, "InvalidVariable");
			} else {
				GameServer server = daemon.getServer();
				Configuration config = server.getConfiguration();
				boolean res = server.setVariable("vars." + var.getName(), value);
				if(res) {
					if(enforced) {
						config.enforce(var, value);
					} else {
						config.unenforce(var);
						config.update(var, value);
					}
					reply(request, "OK");
				} else {
					reply(request, "InvalidValue");
				}
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void get(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			String variableName = request.get(0);
			
			Configuration.Variable var = Configuration.Variable.get(variableName);
			if(var == null) {
				reply(request, "InvalidVariable");
			} else {
				GameServer server = daemon.getServer();
				Configuration config = server.getConfiguration();
				
				boolean enforced = config.isEnforced(var);
				String value = config.get(var);
				reply(request, "OK", value, String.valueOf(enforced));
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void clear(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			String variableName = request.get(0);
			
			Configuration.Variable var = Configuration.Variable.get(variableName);
			if(var == null) {
				reply(request, "InvalidVariable");
			} else {
				GameServer server = daemon.getServer();
				Configuration config = server.getConfiguration();
				
				config.unenforce(var);
				reply(request, "OK");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void list(Admin user, Command request) throws IOException {
		int vars = Configuration.Variable.values().length;
		String[] args = new String[vars + 1];
		int i = 0;
		args[i++] = String.valueOf(vars);
		for(Configuration.Variable var : Configuration.Variable.values()) {
			args[i++] = var.getName();
		}
		reply(request, "OK", args);
	}
	
	public void all(Admin user, Command request) throws IOException {
		ArrayList<String> args = new ArrayList<String>();
		
		int vars = Configuration.Variable.values().length;
		args.add(String.valueOf(vars));
		
		GameServer server = daemon.getServer();
		Configuration config = server.getConfiguration();
		
		for(Configuration.Variable var : Configuration.Variable.values()) {
			args.add(var.getName());
			args.add(config.get(var));
			args.add(String.valueOf(config.isEnforced(var)));
		}
		reply(request, "OK", args.toArray(new String[] {}));
	}
	
	/*
	 * public void apply(Admin user, Command request) throws IOException {
	 * if(daemon.getServer().applyConfiguration()) { reply(request, "OK"); }
	 * else { reply(request, "ServerError"); } }
	 * 
	 * public void read(Admin user, Command request) throws IOException {
	 * reply(request, "NotYetImplemented"); // ServerConfiguration config =
	 * daemon.getServer().getConfig(); //
	 * config.readConfiguration(daemon.getConnection()); // config.save(); //
	 * reply(request, "OK"); }
	 */

}
