package rcon.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;

import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.ingame.ServerMessage;
import rcon.ingame.ServerMessages;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public class MessageModule extends CommandModule {
	
	public MessageModule(RCONOutputStream out, RCONDaemon daemon) {
		super(out, daemon);
	}
	
	public void list(Admin user, Command request) throws IOException {
		ServerMessages serverMessages = daemon.getServer().getServerMessages();
		ArrayList<ServerMessage> messages = serverMessages.getMessages();
		
		String[] arguments = new String[1 + 2 * messages.size()];
		arguments[0] = String.valueOf(messages.size());
		for(int i = 0; i < messages.size(); i++) {
			arguments[1 + 2 * i] = String.valueOf(messages.get(i).getId());
			arguments[1 + 2 * i + 1] = messages.get(i).getMessage();
		}
		reply(request, "OK", arguments);
	}
	
	public void add(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			String message = request.get(0);
			ServerMessages serverMessages = daemon.getServer().getServerMessages();
			ServerMessage m = serverMessages.addMessage(message);
			log(user, "Added server message '" + message + "'.");
			reply(request, "OK", String.valueOf(m.getId()));
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void edit(Admin user, Command request) throws IOException {
		if(request.size() == 2) {
			int id = request.getInt(0);
			String message = request.get(1);
			ServerMessages serverMessages = daemon.getServer().getServerMessages();
			try {
				serverMessages.setMessage(id, message);
				log(user, "Changed server message to '" + message + "'.");
				reply(request, "OK");
			} catch(NoSuchElementException e) {
				reply(request, "UnknownMessage");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void remove(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			int id = request.getInt(0);
			ServerMessages serverMessages = daemon.getServer().getServerMessages();
			try {
				ServerMessage m = serverMessages.get(id);
				serverMessages.remove(id);
				if(m != null) {
					log(user, "Removed server message '" + m.getMessage() + "'.");
				}
				reply(request, "OK");
			} catch(NoSuchElementException e) {
				reply(request, "UnknownMessage");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
}
