package rcon.client;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;
import rcon.players.Player;
import rcon.server.GameServer;

public class PlayerModule extends CommandModule {
	
	public PlayerModule(RCONOutputStream out, RCONDaemon daemon) {
		super(out, daemon);
	}
	
	public void list(Admin user, Command request) throws IOException {
		ArrayList<Player> players = daemon.getServer().getOnline().getPlayers();
		String[] args = new String[1 + players.size() * 6];
		args[0] = String.valueOf(players.size());
		int i = 1;
		for(Player p : players) {
			args[i++] = String.valueOf(p.getId());
			args[i++] = p.getName();
			args[i++] = p.getEaGuid();
			args[i++] = p.getPbGuid();
			args[i++] = p.getIp();
			args[i++] = p.isAdmin() ? String.valueOf(p.getAdmin().getId()) : "0";
		}
		reply(request, "OK", args);
	}
	
	public void search(Admin user, Command request) throws IOException {
		if(request.size() == 4) {
			try {
				String method = request.get(0);
				String string = request.get(1);
				int offset = request.getInt(2);
				int limit = request.getInt(3);
				
				if(limit > 100) {
					reply(request, "InvalidArguments");
				} else if(method.equals("partial")) {
					ArrayList<Player> players = daemon.getDatabase().players.find(string, offset, limit);
					String[] args = new String[1 + players.size() * 5];
					args[0] = String.valueOf(players.size());
					int i = 1;
					for(Player p : players) {
						args[i++] = String.valueOf(p.getId());
						args[i++] = p.getName();
						args[i++] = p.getEaGuid();
						args[i++] = p.getPbGuid();
						args[i++] = p.getIp();
					}
					reply(request, "OK", args);
				} else {
					reply(request, "InvalidMethod");
				}
				
			} catch(NumberFormatException e) {
				reply(request, "InvalidArguments");
			} catch(SQLException e) {
				reply(request, "ServerError");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void yell(Admin user, Command request) throws IOException {
		if(request.size() >= 2) {
			String message = request.get(0);
			String targetType = request.get(1);
			
			GameServer server = daemon.getServer();
			if(targetType.equals("all") && request.size() == 2) {
				server.say(message);
				log(user, "Yelled '" + message + "' to everyone.");
				reply(request, "OK");
			} else if(targetType.equals("player") && request.size() == 3) {
				String target = request.get(2);
				Player p = server.getOnline().getByName(target);
				if(p != null) {
					server.say(message, p);
					log(user, "Yelled '" + message + "' to '" + target + "'.");
					reply(request, "OK");
				} else {
					reply(request, "InvalidTarget");
				}
			} else {
				reply(request, "InvalidArguments");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void say(Admin user, Command request) throws IOException {
		if(request.size() >= 2) {
			String message = request.get(0);
			String targetType = request.get(1);
			
			GameServer server = daemon.getServer();
			if(targetType.equals("all") && request.size() == 2) {
				server.say(message);
				log(user, "Said '" + message + "' to everyone.");
				reply(request, "OK");
			} else if(targetType.equals("player") && request.size() == 3) {
				String target = request.get(2);
				Player p = server.getOnline().getByName(target);
				if(p != null) {
					server.say(message, p);
					log(user, "Said '" + message + "' to '" + target + "'.");
					reply(request, "OK");
				} else {
					reply(request, "InvalidTarget");
				}
			} else {
				reply(request, "InvalidArguments");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
}
