package rcon.client;

import java.io.IOException;

import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public class PunkbusterModule extends CommandModule {
	
	public PunkbusterModule(RCONOutputStream out, RCONDaemon daemon) {
		super(out, daemon);
	}
	
	public void execute(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			String command = request.get(0);
			boolean res = daemon.getServer().punkbuster(command);
			if(res) {
				reply(request, "OK");
				log(user, "Issued punkbuster command '" + command + "'.");
			} else {
				reply(request, "InvalidCommand");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
}
