package rcon.client.swing;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectionDialog extends JDialog implements ActionListener {
	
	private JButton			cancel;
	private JButton			ok;
	private JPasswordField	password;
	private JTextField		username;
	private JTextField		port;
	private JTextField		host;
	private boolean			submitted;
	
	public ConnectionDialog() {
		super((Dialog)null, "Connect to daemon", true);
		
		submitted = false;
		
		setLayout(new GridLayout(5, 2, 10, 10));
		add(new JLabel("Host:"));
		add(host = new JTextField("localhost"));
		
		add(new JLabel("Port:"));
		add(port = new JTextField("5390"));
		
		add(new JLabel("Username:"));
		add(username = new JTextField());
		
		add(new JLabel("Password:"));
		add(password = new JPasswordField());
		
		add(cancel = new JButton("Cancel"));
		add(ok = new JButton("Ok"));
		
		ok.addActionListener(this);
		cancel.addActionListener(this);
		getRootPane().setDefaultButton(ok);
		
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentShown(ComponentEvent ce) {
				host.requestFocusInWindow();
			}
		});
		
		pack();
		
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == ok) {
			submitted = true;
			setVisible(false);
		} else if(e.getSource() == cancel) {
			submitted = false;
			setVisible(false);
		}
	}
	
	@Override
	public void setVisible(boolean b) {
		if(b) {
			submitted = false;
		}
		super.setVisible(b);
	}
	
	public String getHost() {
		return host.getText();
	}
	
	public String getPort() {
		return port.getText();
	}
	
	public String getUsername() {
		return username.getText();
	}
	
	public char[] getPassword() {
		return password.getPassword();
	}
	
	public boolean isSubmitted() {
		return submitted;
	}
	
}
