package rcon.client.swing;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;

import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Main {
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch(Exception e) {}
		
		ConnectionDialog connection = new ConnectionDialog();
		connection.setVisible(true);
		while(connection.isSubmitted()) {
			try {
				Socket socket = new Socket(connection.getHost(), Integer.parseInt(connection
							.getPort()));
				DaemonConnection daemon = new DaemonConnection(socket);
				char[] passwordChars = connection.getPassword();
				String password = new String(passwordChars);
				Arrays.fill(passwordChars, '\0');
				if(daemon.login(connection.getUsername(), password)) {
					new MainWindow(daemon);
					break;
				} else {
					JOptionPane.showMessageDialog(null, "Invalid login.");
				}
			} catch(NumberFormatException e) {
				JOptionPane.showMessageDialog(null, "Invalid port.");
			} catch(IOException e) {
				JOptionPane.showMessageDialog(null, "Failed to connect to daemon.");
			}
			connection.setVisible(true);
		}
		connection.dispose();
	}
	
}
