package rcon.client.swing;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import rcon.client.swing.admin.AdminPane;
import rcon.client.swing.ban.BanPane;

public class MainWindow extends JFrame implements ChangeListener {
	
	private JTabbedPane	tabbedPane;
	private Component	currentSelection;
	
	public MainWindow(DaemonConnection daemon) {
		super("TGAC JE v0.1 pre-alpha");
		currentSelection = null;
		add(tabbedPane = new JTabbedPane());
		
		tabbedPane.addChangeListener(this);
		tabbedPane.addTab("Admins", new AdminPane(daemon));
		tabbedPane.addTab("Bans", new BanPane(daemon));
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(new Dimension(600, 400));
		setVisible(true);
		
	}
	
	@Override
	public void stateChanged(ChangeEvent e) {
		Component component = tabbedPane.getSelectedComponent();
		if(component != currentSelection && component instanceof ModulePane) {
			ModulePane tab = (ModulePane)component;
			tab.onSelected();
			currentSelection = component;
		}
	}
	
}
