/**
 * 
 */
package rcon.client.swing.admin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EnumSet;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import rcon.client.swing.DaemonConnection;
import rcon.players.Admin;
import rcon.players.Right;

class AdminInformationPanel extends JPanel implements ActionListener {
	/**
	 * 
	 */
	private final AdminPane		adminPane;
	private Admin				admin;
	private JButton				rights;
	private JButton				changePassword;
	private JButton				changeGuid;
	private DaemonConnection	daemon;
	
	public AdminInformationPanel(AdminPane adminPane, DaemonConnection daemon, Admin admin) {
		this.adminPane = adminPane;
		this.daemon = daemon;
		this.admin = admin;
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		JComponent c;
		add(c = new JLabel("Admin ID: " + admin.getId()));
		c.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		add(c = new JLabel("User name: " + admin.getUserName()));
		c.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		add(c = new JLabel("GUID: " + admin.getGuid()));
		c.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		add(rights = new JButton("Manage rights"));
		rights.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		add(changePassword = new JButton("Change password"));
		changePassword.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		add(changeGuid = new JButton("Change guid"));
		changeGuid.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		changePassword.addActionListener(this);
		rights.addActionListener(this);
		changeGuid.addActionListener(this);
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == rights) {
			RightsDialog dialog = new RightsDialog(admin.getRights());
			dialog.setVisible(true);
			if(dialog.isSubmitted()) {
				EnumSet<Right> rights = dialog.getRights();
				try {
					if(daemon.setAdminRights(admin.getId(), rights)) {
						admin.setRights(rights);
					} else {
						JOptionPane.showMessageDialog(null, "Failed to apply admin rights.");
						this.adminPane.refreshInfo();
					}
				} catch(IOException ex) {
					JOptionPane.showMessageDialog(null, "Failed to apply admin rights.");
				}
			}
		} else if(e.getSource() == changePassword) {
			ChangePasswordDialog dialog = new ChangePasswordDialog();
			dialog.setVisible(true);
			if(dialog.isSubmitted()) {
				String password = dialog.getPassword();
				try {
					if(!daemon.setAdminPassword(admin.getId(), password)) {
						JOptionPane.showMessageDialog(null, "Failed to change password.");
					} else {
						this.adminPane.refreshInfo();
					}
				} catch(IOException e1) {
					JOptionPane.showMessageDialog(null, "Failed to change password.");
				}
			}
		} else if(e.getSource() == changeGuid) {
			ChangeGuidDialog dialog = new ChangeGuidDialog(daemon);
			dialog.setVisible(true);
			if(dialog.isSubmitted()) {
				admin.setGuid(dialog.getGuid());
				try {
					if(!daemon.editAdmin(admin)) {
						JOptionPane.showMessageDialog(null, "Could not change GUID.");
					}
				} catch(IOException e1) {
					JOptionPane.showMessageDialog(null, "Could not change GUID.");
				}
				this.adminPane.refreshInfo();
			}
		}
	}
}