package rcon.client.swing.admin;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;

import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import rcon.client.swing.DaemonConnection;
import rcon.client.swing.ModulePane;
import rcon.players.Admin;
import rcon.players.Right;

public class AdminPane extends ModulePane implements ActionListener, ListSelectionListener {
	
	private ArrayList<Admin>	admins;
	private JList				list;
	private JButton				register;
	private JSplitPane			split;
	
	public AdminPane(DaemonConnection daemon) {
		super(daemon);
		admins = new ArrayList<Admin>();
		
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		
		list = new JList(new AdminListModel());
		JScrollPane scroll = new JScrollPane(list);
		register = new JButton("Register...");
		register.addActionListener(this);
		JPanel listPanel = new JPanel(new BorderLayout());
		listPanel.add(scroll, BorderLayout.CENTER);
		listPanel.add(register, BorderLayout.SOUTH);
		listPanel.setMinimumSize(new Dimension(150, 50));
		JPanel infoPanel = new JPanel();
		split = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, listPanel, infoPanel);
		split.setDividerLocation(150);
		add(split);
		list.addListSelectionListener(this);
	}
	
	@Override
	public void onSelected() {
		refresh();
	}
	
	private void refresh() {
		try {
			admins = daemon.getAdmins();
			Collections.sort(admins, new Comparator<Admin>() {
				@Override
				public int compare(Admin o1, Admin o2) {
					return o1.getUserName().compareTo(o2.getUserName());
				}
			});
			list.setModel(new AdminListModel());
		} catch(IOException e) {
			e.printStackTrace();
		}
	}
	
	private class AdminListModel extends AbstractListModel {
		@Override
		public Object getElementAt(int index) {
			return admins.get(index).getUserName();
		}
		
		@Override
		public int getSize() {
			return admins.size();
		}
		
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == register) {
			RegisterAdminDialog dialog = new RegisterAdminDialog(daemon);
			while(true) {
				dialog.setVisible(true);
				if(dialog.isSubmitted()) {
					String username = dialog.getUsername();
					String password = dialog.getPassword();
					String guid = dialog.getGuid();
					Admin admin = new Admin(0, guid, username, password, EnumSet
								.noneOf(Right.class));
					try {
						if(daemon.registerAdmin(admin)) {
							refresh();
							break;
						} else {
							JOptionPane.showMessageDialog(this,
										"That GUID or user name is not available.");
						}
					} catch(IOException e1) {
						JOptionPane.showMessageDialog(this, "Failed to register admin.");
						break;
					}
				} else {
					break;
				}
			}
		}
	}
	
	@Override
	public void valueChanged(ListSelectionEvent e) {
		if(!e.getValueIsAdjusting()) {
			refreshInfo();
		}
	}
	
	void refreshInfo() {
		int index = list.getSelectedIndex();
		if(index == -1) {
			split.setRightComponent(new JLabel("No admin selected."));
		} else {
			Admin selected = admins.get(index);
			try {
				selected = daemon.getAdmin(selected.getId());
				split.setRightComponent(new AdminInformationPanel(this, daemon, selected));
			} catch(IOException e1) {
				split
							.setRightComponent(new JLabel("Failed to load "
										+ selected.getUserName() + "."));
			}
		}
	}
	
}
