package rcon.client.swing.admin;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import rcon.client.swing.DaemonConnection;
import rcon.client.swing.PlayerSearchDialog;
import rcon.players.Player;

public class ChangeGuidDialog extends JDialog implements ActionListener {
	private JTextField			guid;
	private JButton				ok;
	private JButton				cancel;
	private boolean				submitted;
	private JButton				find;
	private DaemonConnection	daemon;
	
	public ChangeGuidDialog(DaemonConnection daemon) {
		super((Dialog)null, "Change guid", true);
		this.daemon = daemon;
		setLayout(new GridLayout(3, 2));
		
		add(new JLabel("GUID:"));
		add(guid = new JTextField());
		
		add(new JPanel());
		add(find = new JButton("Find..."));
		
		add(ok = new JButton("Ok"));
		add(cancel = new JButton("Cancel"));
		
		ok.addActionListener(this);
		cancel.addActionListener(this);
		find.addActionListener(this);
		
		getRootPane().setDefaultButton(ok);
		
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentShown(ComponentEvent ce) {
				guid.requestFocusInWindow();
			}
		});
		
		pack();
	}
	
	@Override
	public void setVisible(boolean b) {
		if(b) {
			submitted = false;
		}
		super.setVisible(b);
	}
	
	public boolean isSubmitted() {
		return submitted;
	}
	
	public String getGuid() {
		return guid.getText();
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == ok) {
			submitted = true;
			setVisible(false);
		} else if(e.getSource() == cancel) {
			submitted = false;
			setVisible(false);
		} else if(e.getSource() == find) {
			PlayerSearchDialog search = new PlayerSearchDialog(daemon);
			search.setVisible(true);
			if(search.isSubmitted()) {
				Player p = search.getPlayer();
				if(p != null) {
					guid.setText(p.getPbGuid());
				}
			}
		}
	}
}
