/**
 * 
 */
package rcon.client.swing.admin;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

class ChangePasswordDialog extends JDialog implements ActionListener {
	
	private boolean			submitted;
	private JPasswordField	pw1;
	private JPasswordField	pw2;
	private JButton			ok;
	private JButton			cancel;
	
	public ChangePasswordDialog() {
		super((Dialog)null, "Change password", true);
		submitted = false;
		
		setLayout(new GridLayout(3, 2));
		
		add(new JLabel("New password:"));
		add(pw1 = new JPasswordField());
		
		add(new JLabel("Repeat password:"));
		add(pw2 = new JPasswordField());
		
		add(ok = new JButton("Ok"));
		add(cancel = new JButton("Cancel"));
		
		pack();
		
		getRootPane().setDefaultButton(ok);
		
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentShown(ComponentEvent e) {
				pw1.requestFocusInWindow();
			}
		});
		
		ok.addActionListener(this);
		cancel.addActionListener(this);
	}
	
	public boolean isSubmitted() {
		return submitted;
	}
	
	public String getPassword() {
		return new String(pw1.getPassword());
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == ok) {
			if(pw1.getPassword().length == 0) {
				JOptionPane.showMessageDialog(this, "Please enter a password.");
			} else if(Arrays.equals(pw1.getPassword(), pw2.getPassword())) {
				submitted = true;
				setVisible(false);
			} else {
				JOptionPane.showMessageDialog(this, "The passwords do not match.");
			}
		} else if(e.getSource() == cancel) {
			submitted = false;
			setVisible(false);
		}
	}
	
	@Override
	public void setVisible(boolean b) {
		if(b) {
			submitted = false;
		}
		super.setVisible(b);
	}
	
}