package rcon.client.swing.admin;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.EnumSet;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import rcon.players.Right;

public class RightsDialog extends JDialog implements ActionListener {
	
	private EnumMap<Right, JCheckBox> data;
	private boolean submitted;
	private JButton apply;
	private JButton cancel;

	public RightsDialog(EnumSet<Right> rights) {
		super((Dialog)null, "Manage rights", true);
		data = new EnumMap<Right, JCheckBox>(Right.class);
		submitted = false;
		
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		for(Right r : Right.values()) {
			JCheckBox checkBox = new JCheckBox(r.name(), rights.contains(r));
			data.put(r, checkBox);
			panel.add(checkBox);
		}
		add(new JScrollPane(panel));
		
		JPanel buttonPanel = new JPanel();
		add(buttonPanel);
		buttonPanel.add(apply = new JButton("Apply"));
		buttonPanel.add(cancel = new JButton("Cancel"));
		
		apply.addActionListener(this);
		cancel.addActionListener(this);
		
		pack();
	}
	
	public EnumSet<Right> getRights() {
		EnumSet<Right> rights = EnumSet.noneOf(Right.class);
		for(Right r : Right.values()) {
			if(data.get(r).isSelected()) {
				rights.add(r);
			}
		}
		return rights;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == apply) {
			submitted = true;
			setVisible(false);
		} else if(e.getSource() == cancel) {
			submitted = false;
			setVisible(false);
		}
	}

	public boolean isSubmitted() {
		return submitted;
	}

	@Override
	public void setVisible(boolean b) {
		if(b) {
			submitted = false;
		}
		super.setVisible(b);
	}
	
}
