package rcon.event;

import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.Configuration;
import rcon.server.GameServer;

public class AutomaticIdleHandler extends RCONEventAdapter {
	
	private static final int	LIMIT_FULL		= 28;
	private static final int	LIMIT_EMPTY		= 16;
	private static final int	TIMEOUT_FULL	= 600;
	private static final int	TIMEOUT_EMPTY	= 0;
	
	private GameServer			server;
	
	public AutomaticIdleHandler(GameServer server) {
		this.server = server;
	}
	
	@Override
	public void onJoin(Player player, String eaGuid) {
		update();
	}
	
	@Override
	public void onLeave(Player player, PlayerInfo info) {
		update();
	}
	
	private void update() {
		int n = server.getOnline().size();
		String timeoutString = server.getConfiguration().get(Configuration.Variable.idleTimeout);
		try {
			int timeout = Integer.parseInt(timeoutString);
			if(n >= LIMIT_FULL && timeout != TIMEOUT_FULL) {
				setTimeout(TIMEOUT_FULL);
			} else if(n <= LIMIT_EMPTY && timeout != TIMEOUT_EMPTY) {
				setTimeout(TIMEOUT_EMPTY);
			}
		} catch(NumberFormatException e) {}
	}
	
	private void setTimeout(int timeout) {
		server.setVariable("vars.idleTimeout", String.valueOf(timeout));
		server.getConfiguration().update(Configuration.Variable.idleTimeout, String.valueOf(timeout));
	}
}
