package rcon.event;

public enum BanDuration {
	moment(5*60), hour(3600), day(3600*24), week(3600*24*7), month(3600*24*28), perm;
	
	private int duration;

	private BanDuration(int duration) {
		this.duration = duration;
	}
	
	private BanDuration() {
		this(0);
	}

	public int getDuration() {
		return duration;
	}
	
	public boolean isPermanent() {
		return duration == 0;
	}
}
