package rcon.event;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;

import org.apache.log4j.Logger;

import rcon.database.Database;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.players.Punishment;
import rcon.players.PunishmentType;
import rcon.server.GameServer;

public class BanEnforcerHandler extends RCONEventAdapter {
	
	static Logger				logger	= Logger.getLogger(BanEnforcerHandler.class);
	
	private Database			db;
	private GameServer			server;
	
	private SimpleDateFormat	dateFormat;
	private TimeZone			timeZone;
	private String				message;
	
	public BanEnforcerHandler(GameServer server, Database db, String dateFormat, String timeZone, String bannedMessage) {
		this.server = server;
		this.db = db;
		this.dateFormat = new SimpleDateFormat(dateFormat);
		this.timeZone = TimeZone.getTimeZone(timeZone);
		this.dateFormat.setTimeZone(this.timeZone);
		this.message = bannedMessage;
	}
	
	@Override
	public void onPbInfo(Player player, String pbGuid, String ip) {
		checkBans(player);
	}
	
	@Override
	public void onAuthenticated(Player p) {
		checkBans(p);
	}
	
	@Override
	public void onJoin(Player player, String eaGuid) {
		checkBans(player);
	}
	
	@Override
	public void onPlayerInfo(Player p, PlayerInfo oldInfo, PlayerInfo info) {
		checkBans(p);
	}
	
	private void checkBans(Player player) {
		try {
			Punishment longest = getBans(player);
			if(longest != null) {
				logger.info("Enforcing ban for player " + player.getName() + ".");
				enforceBan(player, longest);
			}
		} catch(SQLException e) {
			logger.error("Database exception when checking and/or enforcing ban.", e);
		}
	}
	
	private void enforceBan(Player player, Punishment longest) throws SQLException {
		Calendar endTime = Calendar.getInstance(timeZone);
		System.out.println(endTime.getTimeZone());
		endTime.setTimeInMillis(longest.getEnd() * 1000);
		String message = String.format(this.message, dateFormat.format(endTime.getTime()),
			db.bans.getReason(longest.getReason()));
		server.disconnect(player, message);
	}
	
	private Punishment getBans(Player player) throws SQLException {
		ArrayList<Punishment> bans = db.bans.getActive(player, PunishmentType.ban);
		Punishment longest = null;
		for(Punishment ban : bans) {
			if(ban.isEnabled() && (longest == null || ban.getEnd() > longest.getEnd())) {
				longest = ban;
			}
		}
		return longest;
	}
	
}
