package rcon.event;

import java.util.ArrayList;

import rcon.players.Player;
import rcon.players.PlayerInfo;

public abstract class RCONEventAdapter implements RCONEventHandler {
	
	@Override
	public void onJoin(Player player, String eaGuid) {}
	
	@Override
	public void onLeave(Player player, PlayerInfo info) {}
	
	@Override
	public void onKill(Player killer, Player killed, String weapon, boolean headshot) {}
	
	@Override
	public void onChat(Player player, String message) {}
	
	@Override
	public void onPbInfo(Player player, String guid, String ip) {}
	
	@Override
	public void onPunkbuster(String message) {}
	
	@Override
	public void onLevelStarted() {}
	
	@Override
	public void onLevelLoaded(String level, String gameMode, int roundsPlayed, int roundsTotal) {}
	
	@Override
	public void onSquadChange(Player p, int team, int squad) {}
	
	@Override
	public void onTeamChange(Player p, int team, int squad) {}
	
	@Override
	public void onKicked(Player p, String reason) {}
	
	@Override
	public void onAuthenticated(Player p) {}
	
	@Override
	public void onPlayerInfo(Player p, PlayerInfo oldInfo, PlayerInfo info) {}
	
	@Override
	public void onSpawn(Player p, boolean first) {}
	
	@Override
	public void onRoundOverPlayers(ArrayList<PlayerInfo> info) {}
	
}
