package rcon.event;

import java.sql.SQLException;
import java.util.ArrayList;

import rcon.database.Database;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.GameServer;
import rcon.server.OnlineList;

public class StatsHandler extends RCONEventAdapter {
	
	private Database	db;
	private GameServer	server;
	
	public StatsHandler(GameServer server, Database db) {
		this.server = server;
		this.db = db;
	}
	
	@Override
	public void onLeave(Player player, PlayerInfo info) {
		try {
			System.out.println(player.getId() + " " + player + " being updated.");
			if(player.getId() != 0) {
				db.stats.updateStats(player, true);
			}
		} catch(SQLException e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void onRoundOverPlayers(ArrayList<PlayerInfo> info) {
		OnlineList online = server.getOnline();
		for(PlayerInfo i : info) {
			Player p = online.getByName(i.getName());
			if(p != null) {
				try {
					if(p.getId() != 0) {
						db.stats.updateStats(p, false);
					}
				} catch(SQLException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
}
