package rcon.net;

import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;

import rcon.MessageType;
import rcon.commands.Command;

public class RCONInputStream {
	
	private static final int	MAX_PACKET_SIZE		= 65535;
	private static final int	MAX_PACKET_WORDS	= 2048;
	private static final int	MAX_WORD_LENGTH		= 65535;
	
	static Logger				logger				= Logger.getLogger(RCONInputStream.class);
	
	private InputStream			in;
	
	public RCONInputStream(InputStream in) {
		this.in = in;
	}
	
	private int readByte() throws IOException {
		int ret = in.read();
		if(ret == -1) {
			throw new IOException("End of stream");
		} else {
			return ret;
		}
	}
	
	private long readU32() throws IOException {
		int a = readByte();
		int b = readByte();
		int c = readByte();
		int d = readByte();
		long ret = ((a | b << 8 | c << 16 | d << 24)) & 0xFFFFFFFFL;
		return ret;
	}
	
	private String readWord() throws IOException {
		int length = (int)readU32();
		if(length > MAX_WORD_LENGTH) {
			throw new IOException("Word size exceeds limit.");
		}
		byte[] data = new byte[length];
		int off = 0;
		while(off < length) {
			int len = in.read(data, off, length - off);
			if(len == -1) {
				throw new IOException("End of stream");
			}
			off += len;
		}
		readByte();
		return new String(data, "US-ASCII");
	}
	
	public Command readCommand() throws IOException {
		// TODO Make sure it checks that we do not read outside our packet.
		// (Buffer the data in advance.)
		long seq = readU32();
		long size = readU32();
		int words = (int)readU32();
		
		if(size > MAX_PACKET_SIZE) {
			throw new IOException("Packet size exceeds limit.");
		}
		if(words > MAX_PACKET_WORDS) {
			throw new IOException("Packet word count exceeds limit.");
		}
		
		String command = readWord();
		
		String[] arguments = new String[words - 1];
		for(int i = 0; i < arguments.length; i++) {
			arguments[i] = readWord();
		}
		MessageType type = MessageType.get((seq & 0xC0000000L));
		
		Command cmd = new Command(command, type, (int)(seq & 0x3FFFFFFFL), arguments);
		logger.trace("<- " + cmd);
		return cmd;
	}
	
}
