package rcon.players;

import java.util.EnumSet;
import java.util.Iterator;

public enum Right {
	/* Access points */
	inGame, console,

	/* Player punishments */
	warn, kick, ban, permBan, kill,

	/* Communication */
	adminChat, yell, whisper, report,

	/* Ban management */
	unban, listBans,

	/* Information */
	playerHistory, rank,

	/* Map control */
	runNextMap, restartMap,

	/* Admin management */
	setRights, registerAdmin, editAdmin,

	/* Server configuration */
	applyConfiguration, changeConfiguration,

	/* Log management */
	adminLogs, chatLogs, eventLogs,

	/* Punkbuster rights */
	pbAdmin,

	/* Miscellaneous */
	editMessages, reservedSlots,

	/* Daemon management */
	shutdownDaemon,

	;
	
	public static EnumSet<Right> parseRights(String... names) {
		EnumSet<Right> rights = EnumSet.noneOf(Right.class);
		for(String name : names) {
			try {
				Right right = Enum.valueOf(Right.class, name);
				rights.add(right);
			} catch(IllegalArgumentException e) {}
		}
		return rights;
	}
	
	public static String toString(EnumSet<Right> rights) {
		StringBuilder sb = new StringBuilder();
		Iterator<Right> it = rights.iterator();
		while(it.hasNext()) {
			sb.append(it.next().name());
			if(it.hasNext()) {
				sb.append(' ');
			}
		}
		return sb.toString();
	}
	
}
