package rcon.server;

import java.util.ArrayList;

import org.apache.log4j.Logger;

import rcon.players.Player;

public class PlayerUpdater implements Runnable {
	
	static Logger				logger	= Logger.getLogger(PlayerUpdater.class);
	
	private GameServer			server;
	private volatile boolean	enabled;
	private int					timeout;
	
	public PlayerUpdater(GameServer server, int timeout) {
		this.server = server;
		this.enabled = true;
		this.timeout = timeout;
	}
	
	@Override
	public void run() {
		if(enabled) {
			server.requestPlayerInfo();
			ArrayList<Player> players = server.getOnline().getPlayers();
			for(Player p : players) {
				long elapsedTime = System.currentTimeMillis() - p.getLastUpdate();
				if(elapsedTime > timeout) {
					logger.info("Player " + p.getName() + " have timed out. Last update was " + elapsedTime / 1000.0
							+ " seconds ago. Removing from cache.");
					server.getOnline().removePlayer(p);
				}
			}
			server.updateInfo();
		} else {
			throw new IllegalStateException("Player updater disabled.");
		}
	}
	
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
}
