package rcon.server;

import java.io.IOException;

import org.apache.log4j.Logger;

import rcon.commands.Command;
import rcon.net.RCONInputStream;

public class ReceiverThread extends Thread {
	
	static Logger				logger	= Logger.getLogger(ReceiverThread.class);
	
	private RCONInputStream		rin;
	private ServerConnection	server;
	
	public ReceiverThread(RCONInputStream rin, ServerConnection server) {
		super("ReceiverThread");
		this.rin = rin;
		this.server = server;
	}
	
	@Override
	public void run() {
		try {
			while(true) {
				Command command = rin.readCommand();
				switch(command.getType()) {
					case server_request:
					case client_request:
						server.addEvent(command);
						break;
					case server_response:
					case client_response:
						server.addResponse(command);
						break;
				}
			}
		} catch(IOException e) {
			logger.trace("Message receiving stopped.");
		}
	}
}
