package httpd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

import rcon.RCONDaemon;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.GameServer;
import rcon.server.OnlineList;

public class RCONHTTPD extends NanoHTTPD {
	
	private RCONDaemon	daemon;
	
	public RCONHTTPD(int port, RCONDaemon daemon) throws IOException {
		super(port);
		this.daemon = daemon;
	}
	
	@Override
	public Response serve(String uri, String method, Properties header, Properties parms) {
		StringBuilder sb = new StringBuilder();
		if(uri.equalsIgnoreCase("/online")) {
			GameServer server = daemon.getServer();
			if(server == null) {
				sb.append("Server offline");
			} else {
				OnlineList online = server.getOnline();
				if(online != null) {
					sb.append(server.getServerName() + "\n");
					sb.append(server.getGameMode() + "\n");
					sb.append(server.getMap() + "\n");
					sb.append(online.size() + "/" + server.getMaxPlayerCount() + "\n");
					sb.append(server.getRoundsPlayed() + "/" + server.getRoundsTotal() + "\n");
					ArrayList<Player> players = online.getPlayers();
					for(Player p : players) {
						sb.append(p.getTag());
						sb.append('\t');
						sb.append(p.getName());
						sb.append('\t');
						
						PlayerInfo info = p.getInfo();
						sb.append(info.getTeam());
						sb.append('\t');
						sb.append(info.getSquad());
						sb.append('\t');
						sb.append(info.getKills());
						sb.append('\t');
						sb.append(info.getDeaths());
						sb.append('\t');
						sb.append(info.getScore());
						sb.append('\t');
						sb.append(info.getPing());
						sb.append('\t');
						sb.append(p.getCreated());
						
						sb.append('\n');
					}
				}
			}
		}
		return new Response(NanoHTTPD.HTTP_OK, NanoHTTPD.MIME_PLAINTEXT, sb.toString());
	}
	
}
