package rcon.client;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import rcon.RCONDaemon;

public class ClientHandler extends Thread {
	
	private List<ClientConnection>	clients;
	private RCONDaemon					daemon;
	private int						port;
	private ServerSocket			socket;
	
	public ClientHandler(RCONDaemon daemon, int port) {
		this.daemon = daemon;
		this.port = port;
		clients = Collections.synchronizedList(new ArrayList<ClientConnection>());
	}
	
	public int getClientCount() {
		return clients.size();
	}
	
	@Override
	public void run() {
		try {
			socket = new ServerSocket(port);
			while(!socket.isClosed()) {
				Socket clientSocket = socket.accept();
				try {
					ClientConnection clientConnection = new ClientConnection(clientSocket, this, daemon);
					clients.add(clientConnection);
					clientConnection.start();
				} catch(IOException e) {
					e.printStackTrace();
				}
			}
		} catch(IOException e) {
			e.printStackTrace();
		}
	}
	
	protected void onClientDisconnect(ClientConnection clientConnection) {
		clients.remove(clientConnection);
	}
	
	public void close() {
		try {
			socket.close();
		} catch(IOException e) {
			e.printStackTrace();
		}
		while(!clients.isEmpty()) {
			clients.remove(0).close();
		}
		try {
			join(500);
		} catch(InterruptedException e) {
			e.printStackTrace();
		}
	}
	
}
