package rcon.client;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.log.AdminLogEntry;
import rcon.log.ChatLogEntry;
import rcon.log.EventLogEntry;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public class LogModule extends CommandModule {
	
	public LogModule(RCONOutputStream out, RCONDaemon daemon) {
		super(out, daemon);
	}
	
	public void admin(Admin user, Command request) throws IOException {
		if(request.size() == 5) {
			try {
				String admin = request.get(0);
				int start = request.getInt(1);
				int end = request.getInt(2);
				int limit = Math.min(request.getInt(3), 100);
				int offset = request.getInt(4);
				List<AdminLogEntry> entries;
				if(admin.equals("all")) {
					entries = daemon.getDatabase().logs.getAdminLogs(start, end, limit, offset);
				} else {
					int adminId = request.getInt(0);
					entries = daemon.getDatabase().logs.getAdminLogs(adminId, start, end, limit, offset);
				}
				
				ArrayList<String> arguments = new ArrayList<String>();
				arguments.add(String.valueOf(entries.size()));
				for(AdminLogEntry e : entries) {
					arguments.add(String.valueOf(e.getTime()));
					arguments.add(String.valueOf(e.getAdmin().getId()));
					arguments.add(e.getAdmin().getUserName());
					arguments.add(e.getMessage());
				}
				reply(request, "OK", arguments.toArray(new String[] {}));
			} catch(SQLException e) {
				reply(request, "ServerError");
			} catch(NumberFormatException e) {
				reply(request, "InvalidArguments");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void chat(Admin user, Command request) throws IOException {
		if(request.size() == 4) {
			try {
				int start = request.getInt(0);
				int end = request.getInt(1);
				int limit = Math.min(request.getInt(2), 100);
				int offset = request.getInt(3);
				List<ChatLogEntry> entries = daemon.getDatabase().logs.getChatLogs(start, end, limit, offset);
				
				ArrayList<String> arguments = new ArrayList<String>();
				arguments.add(String.valueOf(entries.size()));
				for(ChatLogEntry e : entries) {
					arguments.add(String.valueOf(e.getTime()));
					arguments.add(e.getFrom());
					arguments.add(e.getTo());
					arguments.add(e.getMessage());
				}
				reply(request, "OK", arguments.toArray(new String[] {}));
			} catch(SQLException e) {
				reply(request, "ServerError");
			} catch(NumberFormatException e) {
				reply(request, "InvalidArguments");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void event(Admin user, Command request) throws IOException {
		if(request.size() == 4) {
			try {
				int start = request.getInt(0);
				int end = request.getInt(1);
				int limit = Math.min(request.getInt(2), 100);
				int offset = request.getInt(3);
				List<EventLogEntry> entries = daemon.getDatabase().logs.getEventLogs(start, end, limit, offset);
				
				ArrayList<String> arguments = new ArrayList<String>();
				arguments.add(String.valueOf(entries.size()));
				for(EventLogEntry e : entries) {
					arguments.add(String.valueOf(e.getTime()));
					arguments.add(e.getMessage());
				}
				reply(request, "OK", arguments.toArray(new String[] {}));
			} catch(SQLException e) {
				reply(request, "ServerError");
			} catch(NumberFormatException e) {
				reply(request, "InvalidArguments");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
}
