package rcon.client;

import java.io.IOException;
import java.util.List;

import rcon.RCONDaemon;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;

public class ReservedSlotsModule extends CommandModule {
	
	public ReservedSlotsModule(RCONOutputStream out, RCONDaemon daemon) {
		super(out, daemon);
	}
	
	public void load(Admin user, Command request) throws IOException {
		boolean ret = daemon.getServer().loadReservedSlots();
		if(ret) {
			reply(request, "OK");
			log(user, "Loaded reserved slots.");
		} else {
			reply(request, "ServerError");
		}
	}
	
	public void save(Admin user, Command request) throws IOException {
		boolean ret = daemon.getServer().saveReservedSlots();
		if(ret) {
			reply(request, "OK");
			log(user, "Saved reserved slots.");
		} else {
			reply(request, "ServerError");
		}
	}
	
	public void list(Admin user, Command request) throws IOException {
		List<String> slots = daemon.getServer().getReservedSlots();
		if(slots == null) {
			reply(request, "ServerError");
		} else {
			slots.add(0, String.valueOf(slots.size()));
			reply(request, "OK", slots.toArray(new String[] {}));
		}
	}
	
	public void clear(Admin user, Command request) throws IOException {
		boolean ret = daemon.getServer().clearReservedSlots();
		if(ret) {
			reply(request, "OK");
			log(user, "Cleared reserved slots.");
		} else {
			reply(request, "ServerError");
		}
	}
	
	public void addPlayer(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			String name = request.get(0);
			boolean ret = daemon.getServer().addReservedSlot(name);
			if(ret) {
				reply(request, "OK");
				log(user, "Added reserved slot for " + name + ".");
			} else {
				reply(request, "InvalidReservedSlot");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
	public void removePlayer(Admin user, Command request) throws IOException {
		if(request.size() == 1) {
			String name = request.get(0);
			boolean ret = daemon.getServer().removeReservedSlot(name);
			if(ret) {
				reply(request, "OK");
				log(user, "Removed reserved slot for " + name + ".");
			} else {
				reply(request, "InvalidReservedSlot");
			}
		} else {
			reply(request, "InvalidArguments");
		}
	}
	
}
