package rcon.client.swing;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import rcon.players.Player;

public class PlayerSearchDialog extends JDialog implements ActionListener {
	
	private boolean				submitted;
	private JButton				ok;
	private JButton				cancel;
	private PlayerSearchPane	search;
	
	public PlayerSearchDialog(DaemonConnection daemon) {
		super((Dialog)null, "Search player", true);
		submitted = false;
		
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		
		add(search = new PlayerSearchPane(daemon));
		JPanel panel = new JPanel();
		add(panel);
		panel.add(ok = new JButton("Ok"));
		panel.add(cancel = new JButton("Cancel"));
		
		ok.addActionListener(this);
		cancel.addActionListener(this);
		
		getRootPane().setDefaultButton(ok);
		
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentShown(ComponentEvent e) {
				search.requestFocusInWindow();
			}
		});
		
		pack();
	}
	
	public Player getPlayer() {
		return search.getSelectedPlayer();
	}
	
	public boolean isSubmitted() {
		return submitted;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == ok) {
			if(search.getSelectedPlayer() == null) {
				JOptionPane.showMessageDialog(null, "Please select a player.");
			} else {
				submitted = true;
				setVisible(false);
			}
		} else {
			submitted = false;
			setVisible(false);
		}
	}
	
}
