package rcon.client.swing;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;

import rcon.players.Player;

public class PlayerSearchPane extends JPanel implements DocumentListener, ActionListener {
	
	private DaemonConnection	daemon;
	private JTextField			search;
	private JTable				table;
	
	private ArrayList<Player>	players;
	private String				current;
	private Timer				refreshTimer;
	private PlayerTableModel	model;
	
	public PlayerSearchPane(DaemonConnection daemon) {
		this.daemon = daemon;
		this.refreshTimer = new Timer(500, this);
		refreshTimer.setRepeats(false);
		this.current = "";
		this.players = new ArrayList<Player>();
		
		setLayout(new BorderLayout());
		
		add(search = new JTextField(), BorderLayout.NORTH);
		
		add(new JScrollPane(table = new JTable()), BorderLayout.CENTER);
		table.setModel(model = new PlayerTableModel());
		table.getColumnModel().getColumn(0).setPreferredWidth(50);
		table.getColumnModel().getColumn(1).setPreferredWidth(200);
		table.getColumnModel().getColumn(2).setPreferredWidth(300);
		table.getColumnModel().getColumn(3).setPreferredWidth(150);
		
		search.getDocument().addDocumentListener(this);
		
	}
	
	@Override
	public boolean requestFocusInWindow() {
		return search.requestFocusInWindow();
	}
	
	public Player getSelectedPlayer() {
		int row = table.getSelectedRow();
		if(row == -1) {
			return null;
		} else {
			return players.get(row);
		}
	}
	
	private void refresh() {
		try {
			current = search.getText();
			players = daemon.searchPlayers(current, 0, 100);
			model.update();
			if(!players.isEmpty()) {
				table.setRowSelectionInterval(0, 0);
			}
		} catch(IOException e) {}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == refreshTimer) {
			System.out.println("Timer");
			if(!search.getText().equals(current) && search.getText().length() >= 3) {
				refresh();
			}
		}
	}
	
	@Override
	public void changedUpdate(DocumentEvent arg0) {
		refreshTimer.restart();
	}
	
	@Override
	public void insertUpdate(DocumentEvent arg0) {
		refreshTimer.restart();
	}
	
	@Override
	public void removeUpdate(DocumentEvent arg0) {
		refreshTimer.restart();
	}
	
	private class PlayerTableModel extends AbstractTableModel {
		
		private final String[]	columnNames	= new String[] {"ID", "Name", "Guid", "IP"};
		
		@Override
		public int getColumnCount() {
			return 4;
		}
		
		@Override
		public int getRowCount() {
			return players.size();
		}
		
		@Override
		public String getColumnName(int column) {
			return columnNames[column];
		}
		
		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			Player p = players.get(rowIndex);
			switch(columnIndex) {
				case 0:
					return p.getId();
				case 1:
					return p.getName();
				case 2:
					return p.getPbGuid();
				case 3:
					return p.getIp();
				default:
					return null;
			}
		}
		
		public void update() {
			fireTableDataChanged();
		}
		
	}
	
}
