package rcon.client.swing.admin;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import rcon.client.swing.DaemonConnection;
import rcon.client.swing.PlayerSearchDialog;
import rcon.players.Player;

public class RegisterAdminDialog extends JDialog implements ActionListener {
	
	private JTextField			username;
	private JPasswordField		pw1;
	private JPasswordField		pw2;
	private JTextField			guid;
	private JButton				ok;
	private JButton				cancel;
	private boolean				submitted;
	private JButton				find;
	private DaemonConnection	daemon;
	
	public RegisterAdminDialog(DaemonConnection daemon) {
		super((Dialog)null, "Register admin", true);
		this.daemon = daemon;
		setLayout(new GridLayout(6, 2));
		
		add(new JLabel("User name:"));
		add(username = new JTextField());
		
		add(new JLabel("Password:"));
		add(pw1 = new JPasswordField());
		
		add(new JLabel("Repeat password:"));
		add(pw2 = new JPasswordField());
		
		add(new JLabel("GUID:"));
		add(guid = new JTextField());
		
		add(new JPanel());
		add(find = new JButton("Find..."));
		
		add(ok = new JButton("Ok"));
		add(cancel = new JButton("Cancel"));
		
		ok.addActionListener(this);
		cancel.addActionListener(this);
		find.addActionListener(this);
		
		getRootPane().setDefaultButton(ok);
		
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentShown(ComponentEvent ce) {
				username.requestFocusInWindow();
			}
		});
		
		pack();
	}
	
	@Override
	public void setVisible(boolean b) {
		if(b) {
			submitted = false;
		}
		super.setVisible(b);
	}
	
	public boolean isSubmitted() {
		return submitted;
	}
	
	public String getUsername() {
		return username.getText();
	}
	
	public String getPassword() {
		return new String(pw1.getPassword());
	}
	
	public String getGuid() {
		return guid.getText();
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == ok) {
			if(username.getText().isEmpty()) {
				JOptionPane.showMessageDialog(this, "Please enter a user name.");
				username.requestFocusInWindow();
			} else if(pw1.getPassword().length == 0) {
				JOptionPane.showMessageDialog(this, "Please enter a password.");
				pw1.requestFocusInWindow();
			} else if(!Arrays.equals(pw1.getPassword(), pw2.getPassword())) {
				JOptionPane.showMessageDialog(this, "Passwords do not match.");
				pw1.requestFocusInWindow();
			} else {
				submitted = true;
				setVisible(false);
			}
		} else if(e.getSource() == cancel) {
			submitted = false;
			setVisible(false);
		} else if(e.getSource() == find) {
			PlayerSearchDialog search = new PlayerSearchDialog(daemon);
			search.setVisible(true);
			if(search.isSubmitted()) {
				Player p = search.getPlayer();
				if(p != null) {
					guid.setText(p.getPbGuid());
				}
			}
		}
	}
	
}
