package rcon.client.swing.ban;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import rcon.client.swing.DaemonConnection;
import rcon.players.Punishment;

public class BanSearchPane extends JPanel implements ActionListener, DocumentListener {
	
	private DaemonConnection	daemon;
	private Timer				refreshTimer;
	private String				current;
	private JTextField			search;
	private BanTable			table;
	
	public BanSearchPane(DaemonConnection daemon) {
		this.daemon = daemon;
		this.refreshTimer = new Timer(500, this);
		refreshTimer.setRepeats(false);
		this.current = "";
		
		setLayout(new BorderLayout());
		
		add(search = new JTextField(), BorderLayout.NORTH);
		
		add(new JScrollPane(table = new BanTable()), BorderLayout.CENTER);
		
		search.getDocument().addDocumentListener(this);
	}
	
	@Override
	public boolean requestFocusInWindow() {
		return search.requestFocusInWindow();
	}
	
	public Punishment getSelectedBan() {
		return table.getSelectedBan();
	}
	
	private void refresh() {
		try {
			current = search.getText();
			table.setBans(daemon.getBansByPartialName(current));
		} catch(IOException e) {}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == refreshTimer) {
			if(!search.getText().equals(current) && search.getText().length() >= 3) {
				refresh();
			}
		}
	}
	
	@Override
	public void changedUpdate(DocumentEvent arg0) {
		refreshTimer.restart();
	}
	
	@Override
	public void insertUpdate(DocumentEvent arg0) {
		refreshTimer.restart();
	}
	
	@Override
	public void removeUpdate(DocumentEvent arg0) {
		refreshTimer.restart();
	}
	
}
