package rcon.client.swing.ban;

import java.util.ArrayList;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

import rcon.players.Punishment;
import rcon.players.PunishmentType;

public class BanTable extends JTable {
	
	private ArrayList<Punishment>	punishments;
	private BanTableModel			model;
	
	public BanTable() {
		this(new ArrayList<Punishment>());
	}
	
	public BanTable(ArrayList<Punishment> punishments) {
		this.punishments = new ArrayList<Punishment>();
		this.punishments.addAll(punishments);
		this.setModel(model = new BanTableModel());
		
		TableColumnModel columns = getColumnModel();
		columns.getColumn(0).setPreferredWidth(150);
		columns.getColumn(1).setPreferredWidth(400);
		columns.getColumn(2).setPreferredWidth(75);
		columns.getColumn(3).setPreferredWidth(100);
		columns.getColumn(4).setPreferredWidth(100);
		columns.getColumn(5).setPreferredWidth(200);
		columns.getColumn(6).setPreferredWidth(150);
		columns.getColumn(7).setPreferredWidth(150);
	}
	
	public void setBans(ArrayList<Punishment> punishments) {
		this.punishments.clear();
		this.punishments.addAll(punishments);
		model.update();
	}
	
	public Punishment getSelectedBan() {
		int index = getSelectedRow();
		if(index == -1) {
			return null;
		} else {
			return punishments.get(index);
		}
	}
	
	private class BanTableModel extends AbstractTableModel {
		
		private final String[]	columns	= new String[] {"Name", "GUID", "Type", "Start", "End",
													"Reason", "Admin", "Status"};
		
		@Override
		public int getColumnCount() {
			return columns.length;
		}
		
		public void update() {
			fireTableDataChanged();
		}
		
		@Override
		public int getRowCount() {
			return punishments.size();
		}
		
		@Override
		public String getColumnName(int column) {
			return columns[column];
		}
		
		@Override
		public Object getValueAt(int row, int col) {
			Punishment p = punishments.get(row);
			switch(col) {
				case 0:
					return p.getName();
				case 1:
					return p.getPbGuid();
				case 2:
					return p.getType().name();
				case 3:
					return p.getStart();
				case 4:
					return p.getEnd();
				case 5:
					return p.getReason();
				case 6:
					return p.getIssuer().getUserName();
				case 7:
					if(!p.isEnabled()) {
						return "lifted";
					} else if(p.getType() == PunishmentType.ban) {
						if(p.getEnd() > System.currentTimeMillis() / 1000) {
							return "in effect";
						} else {
							return "expired";
						}
					} else {
						return "";
					}
				default:
					return null;
			}
		}
		
	}
	
}
