package rcon.commands;

import rcon.MessageType;

public class Command {
	
	public static final Command	EOF	= new Command();
	private String				name;
	private String[]			arguments;
	private int					seq;
	private MessageType			type;
	
	public Command(String name, MessageType type, int seq, String... arguments) {
		this.name = name;
		this.arguments = arguments;
		this.type = type;
		this.seq = seq;
	}
	
	public Command(String name, MessageType type, String... arguments) {
		this.name = name;
		this.arguments = arguments;
		this.type = type;
		this.seq = 0;
	}
	
	private Command() {}
	
	public String getName() {
		return name;
	}
	
	public String[] getArguments() {
		return arguments;
	}
	
	protected void setArguments(String[] arguments) {
		this.arguments = arguments;
	}
	
	public int size() {
		return arguments.length;
	}
	
	public String get(int i) {
		return arguments[i];
	}
	
	public int getInt(int i) {
		return Integer.parseInt(get(i));
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append('[');
		sb.append(seq);
		sb.append(',');
		sb.append(getType());
		sb.append(']');
		sb.append(' ');
		sb.append(name);
		sb.append(' ');
		for(String argument : arguments) {
			sb.append(argument);
			sb.append(' ');
		}
		return sb.toString();
	}
	
	public MessageType getType() {
		return type;
	}
	
	public int getSeq() {
		return seq;
	}
	
	public void setSeq(int i) {
		seq = i;
	}
	
	public boolean is(String string) {
		return name.equals(string);
	}
	
}
